/*
 * Decompiled with CFR 0.152.
 */
package javaprinter;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javaprinter.ConfigReader;
import javaprinter.DumpDevices;
import javaprinter.OperationMode;
import javaprinter.ReceiptWorker;
import javaprinter.json.Config;
import javaprinter.logo.LogoPrinter;
import javax.imageio.ImageIO;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.usb.UsbException;
import org.apache.commons.codec.binary.Base64;

public class Main {
    private static int fl = 16;
    private static String version = "2.2";

    public static void main(String[] args) {
        OperationMode opMode = new OperationMode();
        int i = 0;
        while (i < args.length) {
            String[] argParts;
            String anArg = args[i];
            if (anArg.compareToIgnoreCase("-version") == 0 || anArg.compareToIgnoreCase("--version") == 0) {
                System.out.println(version);
                System.exit(0);
            }
            if ((argParts = anArg.split("=")).length >= 2) {
                String value = argParts[1];
                if (argParts[0].compareToIgnoreCase("-mode") == 0 || argParts[0].compareToIgnoreCase("--mode") == 0) {
                    if (value.compareToIgnoreCase("dump") == 0) {
                        opMode.setOnlydump(true);
                    } else if (value.compareToIgnoreCase("legacy-cups") == 0) {
                        opMode.setCups(true);
                        opMode.setLegacy(true);
                    } else if (value.compareToIgnoreCase("cups") == 0) {
                        opMode.setCups(true);
                        opMode.setLegacy(false);
                    } else if (value.compareToIgnoreCase("legacy") == 0) {
                        opMode.setCups(false);
                        opMode.setLegacy(true);
                    }
                } else if (argParts[0].compareToIgnoreCase("-security") == 0 || argParts[0].compareToIgnoreCase("--security") == 0) {
                    if (value.compareToIgnoreCase("weakssl") == 0) {
                        opMode.setWeakssl(true);
                    }
                } else if (argParts[0].compareToIgnoreCase("-print") == 0 || argParts[0].compareToIgnoreCase("--print") == 0) {
                    if (value.compareToIgnoreCase("test") == 0) {
                        opMode.setTestmode(true);
                    }
                } else if (argParts[0].compareToIgnoreCase("-protocol") == 0 || argParts[0].compareToIgnoreCase("--protocol") == 0) {
                    if (value.compareToIgnoreCase("allowbigpackets") == 0) {
                        opMode.setAllowBigPackets(true);
                    }
                } else if (argParts[0].compareToIgnoreCase("-configfile") == 0 || argParts[0].compareToIgnoreCase("--configfile") == 0) {
                    opMode.setConfigFile(value);
                } else if (argParts[0].compareToIgnoreCase("-cupsprinter") == 0 || argParts[0].compareToIgnoreCase("--cupsprinter") == 0) {
                    opMode.setCupsPrintername(value);
                } else if (argParts[0].compareToIgnoreCase("-imagelinespacing") == 0 || argParts[0].compareToIgnoreCase("--imagelinespacing") == 0) {
                    opMode.setImageLineSpacing(value);
                } else if (argParts[0].compareToIgnoreCase("-imagelinefeed") == 0 || argParts[0].compareToIgnoreCase("-imagelinefeed") == 0) {
                    opMode.setImageLineFeed(value);
                }
            }
            ++i;
        }
        String configFile = opMode.getConfigFile();
        if (configFile.compareToIgnoreCase("") == 0) {
            System.err.println("Syntax: java -jar javaprinter.jar mode=dump|cups|legacy-cups|legacy -security=weakssl -protocol=allowbugpackets -cupsprinter=Printername -imagelinespacing=27,51,24 -imagelinefeed=10(,10) -configfile=/opt/bin/config.json");
            System.err.println("   The arguments except the config file are optional.");
            return;
        }
        if (opMode.isOnlydump()) {
            DumpDevices dumpDevices = new DumpDevices();
            try {
                DumpDevices.dump();
                return;
            }
            catch (UsbException e) {
                e.printStackTrace();
            }
        }
        System.out.println("Javaprinter version " + version);
        System.out.println("Operation mode: ");
        System.out.println(opMode.toString());
        if (opMode.isCups()) {
            System.out.println("CUPS information:");
            PrintService[] printServices = PrintServiceLookup.lookupPrintServices(null, null);
            System.out.println("  Number of print services: " + printServices.length);
            System.out.println("  Available printer: ");
            PrintService[] printServiceArray = printServices;
            int n = printServices.length;
            int value = 0;
            while (value < n) {
                PrintService printer = printServiceArray[value];
                System.out.println(printer.getName());
                ++value;
            }
            PrintService defaultPrinter = PrintServiceLookup.lookupDefaultPrintService();
            if (defaultPrinter != null) {
                System.out.println("  Default printer: " + defaultPrinter.getName());
                if (!opMode.isCupsPrinterNameSet()) {
                    opMode.setCupsPrintername(defaultPrinter.getName());
                    System.out.println("  Cups printer not set by arguments. Set printing to default printer.");
                }
            }
        }
        boolean configRead = false;
        Config config = null;
        while (!configRead) {
            config = new ConfigReader().getConfig(configFile, opMode.isWeakssl(), fl);
            if (config == null) {
                System.err.println("Cannot access config from webserver - wait for some time and retry");
                try {
                    System.err.println("Cannot access webserver - wait for some time and retry");
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            System.out.println("Config: " + config);
            URL url = null;
            if (opMode.isLegacy()) {
                try {
                    url = new URL(String.valueOf(config.baseurl) + "/php/contenthandler.php?module=printqueue&command=getLogoAsPng");
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    try {
                        System.err.println("Cannot access webserver - wait for some time and retry");
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
                try {
                    URLConnection uc = url.openConnection();
                    uc.setRequestProperty("Authorization", "Basic " + new String(Base64.encodeBase64((byte[])(String.valueOf(config.baseusername) + ":" + config.basepass).getBytes())));
                    BufferedImage img = ImageIO.read(uc.getInputStream());
                    LogoPrinter lp = new LogoPrinter();
                    if (img != null) {
                        config.insertLogoBytes(lp.getImageAsBytes(img, config.logoscale, config.printersize, opMode.getImageLineSpacing(), opMode.getImageLineFeed()));
                    }
                }
                catch (IOException e) {
                    try {
                        System.err.println(" Cannot set logo into config, maybe web server not accessible - wait for some time and retry");
                        Thread.sleep(5000L);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            }
            configRead = true;
        }
        int counterpollbills = 0;
        int counterpollworksf = 0;
        int counterpollworksd = 0;
        int counterpollclosings = 0;
        int counterpollpickups = 0;
        while (true) {
            try {
                if (!opMode.isLegacy()) {
                    if (counterpollbills == 0) {
                        ReceiptWorker.fetchAndPrintTickets(config, opMode, fl);
                        counterpollbills = config.pollbills;
                    } else {
                        --counterpollbills;
                    }
                }
                if (opMode.isLegacy()) {
                    if (counterpollbills == 0) {
                        ReceiptWorker.fetchAndPrintReceiptJobs(config, opMode, fl);
                        counterpollbills = config.pollbills;
                    } else {
                        --counterpollbills;
                    }
                    if (counterpollclosings == 0) {
                        ReceiptWorker.fetchAndPrintClosingJobs(config, opMode, fl);
                        counterpollclosings = config.pollclosings;
                    } else {
                        --counterpollclosings;
                    }
                    if (counterpollpickups == 0) {
                        ReceiptWorker.fetchAndPrintPickupJobs(config, opMode, fl);
                        counterpollpickups = config.pollpickups;
                    } else {
                        --counterpollpickups;
                    }
                    if (counterpollworksf == 0) {
                        ReceiptWorker.fetchAndPrintFoodWorkJobs1(config, opMode, fl);
                        ReceiptWorker.fetchAndPrintFoodWorkJobs2(config, opMode, fl);
                        ReceiptWorker.fetchAndPrintFoodWorkJobs3(config, opMode, fl);
                        ReceiptWorker.fetchAndPrintFoodWorkJobs4(config, opMode, fl);
                        ReceiptWorker.fetchAndPrintCancelFoodWorkJobs1(config, opMode, fl);
                        ReceiptWorker.fetchAndPrintCancelFoodWorkJobs2(config, opMode, fl);
                        ReceiptWorker.fetchAndPrintCancelFoodWorkJobs3(config, opMode, fl);
                        ReceiptWorker.fetchAndPrintCancelFoodWorkJobs4(config, opMode, fl);
                        counterpollworksf = config.pollworksf;
                    } else {
                        --counterpollworksf;
                    }
                    if (counterpollworksd == 0) {
                        ReceiptWorker.fetchAndPrintDrinkWorkJobs1(config, opMode, fl);
                        ReceiptWorker.fetchAndPrintDrinkWorkJobs2(config, opMode, fl);
                        ReceiptWorker.fetchAndPrintDrinkWorkJobs3(config, opMode, fl);
                        ReceiptWorker.fetchAndPrintDrinkWorkJobs4(config, opMode, fl);
                        ReceiptWorker.fetchAndPrintCancelDrinkWorkJobs1(config, opMode, fl);
                        ReceiptWorker.fetchAndPrintCancelDrinkWorkJobs2(config, opMode, fl);
                        ReceiptWorker.fetchAndPrintCancelDrinkWorkJobs3(config, opMode, fl);
                        ReceiptWorker.fetchAndPrintCancelDrinkWorkJobs4(config, opMode, fl);
                        counterpollworksd = config.pollworksd;
                    } else {
                        --counterpollworksd;
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Exception in main loop catched");
                e.printStackTrace();
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }
}

