/*
 * Decompiled with CFR 0.152.
 */
package javaprinter.json.receipt;

import javaprinter.genutils.GenUtils;
import javaprinter.json.IEntry;
import javaprinter.json.IReceipt;
import javaprinter.json.receipt.Overallinfo;
import javaprinter.json.receipt.Product;
import javaprinter.json.receipt.Taxes;
import javaprinter.json.receipt.Translations;

public class Bill
implements IReceipt {
    public Overallinfo billoverallinfo;
    public Translations translations;
    public Product[] products;
    public Taxes[] taxes;

    @Override
    public IEntry[] getLoopEntries(String key) {
        if (key.compareToIgnoreCase("products") == 0) {
            return this.products;
        }
        if (key.compareToIgnoreCase("taxes") == 0) {
            return this.taxes;
        }
        return new Product[0];
    }

    private String getTableOrTogo(boolean useTablePrefix) {
        String table = this.billoverallinfo.table;
        if (table.compareTo("-") != 0) {
            if (useTablePrefix) {
                return GenUtils.cutText(String.valueOf(this.translations.table) + table, 25);
            }
            return GenUtils.cutText(table, 25);
        }
        return "Zum Mitnehmen";
    }

    private String double2Str(double value, String decpoint) {
        return String.format("%.2f", value).replace(".", decpoint);
    }

    @Override
    public String renderValueAsString(String fieldId, String decpoint, String currency) {
        String valueStr = "";
        if (fieldId.compareToIgnoreCase("a") == 0) {
            valueStr = String.valueOf(valueStr) + this.billoverallinfo.id;
        } else if (fieldId.compareToIgnoreCase("b") == 0) {
            valueStr = String.valueOf(valueStr) + this.getTableOrTogo(false);
        } else if (fieldId.compareToIgnoreCase("c") == 0) {
            valueStr = String.valueOf(valueStr) + this.billoverallinfo.username;
        } else if (fieldId.compareToIgnoreCase("d") == 0) {
            Overallinfo b = this.billoverallinfo;
            valueStr = String.valueOf(valueStr) + b.billday + "." + b.billmonth + "." + b.billyear + " " + b.billhour + ":" + b.billmin;
        } else if (fieldId.compareToIgnoreCase("e") == 0) {
            valueStr = String.valueOf(valueStr) + this.double2Str(this.billoverallinfo.brutto, decpoint) + " " + currency;
        } else if (fieldId.compareToIgnoreCase("g") == 0) {
            valueStr = String.valueOf(valueStr) + this.translations.waiter;
        } else if (fieldId.compareToIgnoreCase("h") == 0) {
            valueStr = String.valueOf(valueStr) + this.translations.table;
        } else if (fieldId.compareToIgnoreCase("i") == 0) {
            valueStr = String.valueOf(valueStr) + this.translations.sum;
        } else if (fieldId.compareToIgnoreCase("k") == 0) {
            valueStr = String.valueOf(valueStr) + this.translations.no;
        } else if (fieldId.compareToIgnoreCase("m") == 0) {
            valueStr = String.valueOf(valueStr) + this.translations.descr;
        } else if (fieldId.compareToIgnoreCase("n") == 0) {
            valueStr = String.valueOf(valueStr) + this.translations.brutto;
        } else if (fieldId.compareToIgnoreCase("o") == 0) {
            valueStr = String.valueOf(valueStr) + this.translations.total;
        } else if (fieldId.compareToIgnoreCase("p") == 0) {
            valueStr = String.valueOf(valueStr) + this.translations.mwst + "%";
        } else if (fieldId.compareToIgnoreCase("q") == 0) {
            valueStr = String.valueOf(valueStr) + this.translations.mwst;
        } else if (fieldId.compareToIgnoreCase("r") == 0) {
            valueStr = String.valueOf(valueStr) + this.translations.netto;
        } else if (fieldId.compareToIgnoreCase("t") == 0) {
            valueStr = String.valueOf(valueStr) + this.getTableOrTogo(true);
        } else if (fieldId.compareToIgnoreCase("u") == 0) {
            valueStr = String.valueOf(valueStr) + this.billoverallinfo.guestinfo;
        } else if (fieldId.compareToIgnoreCase("x") == 0) {
            Overallinfo b = this.billoverallinfo;
            valueStr = String.valueOf(valueStr) + b.billday + "." + b.billmonth + "." + b.billyear;
        } else if (fieldId.compareToIgnoreCase("y") == 0) {
            Overallinfo b = this.billoverallinfo;
            valueStr = String.valueOf(valueStr) + b.billhour + ":" + b.billmin;
        } else if (fieldId.compareToIgnoreCase("z") == 0) {
            valueStr = String.valueOf(valueStr) + this.billoverallinfo.payment;
        } else if (fieldId.compareToIgnoreCase("sn") == 0) {
            valueStr = String.valueOf(valueStr) + this.billoverallinfo.sn;
        } else if (fieldId.compareToIgnoreCase("uid") == 0) {
            valueStr = String.valueOf(valueStr) + this.billoverallinfo.uid;
        } else if (fieldId.compareToIgnoreCase("version") == 0) {
            valueStr = String.valueOf(valueStr) + this.billoverallinfo.version;
        } else if (fieldId.compareToIgnoreCase("kassenid") == 0) {
            valueStr = String.valueOf(valueStr) + this.billoverallinfo.systemid;
        } else if (fieldId.compareToIgnoreCase("betriebsinfo") == 0) {
            valueStr = String.valueOf(valueStr) + this.billoverallinfo.companyinfo;
        }
        return valueStr;
    }

    @Override
    public boolean printHostPart() {
        int host = Integer.parseInt(this.billoverallinfo.host);
        return host == 1;
    }
}

