/*
 * Decompiled with CFR 0.152.
 */
package tseconnector.commands;

import com.secureflashcard.wormapi.WormInitializationState;
import com.secureflashcard.wormapi.WormStore;
import com.secureflashcard.wormapi.WormUserId;
import java.nio.charset.StandardCharsets;
import tseconnector.ITseStatus;
import tseconnector.TseConnectorLog;
import tseconnector.commands.CommandResult;

public class TseCmdExecutor {
    public static CommandResult selftest(ITseStatus tseStatus, boolean force, String mountPoint, String clientid, TseConnectorLog logger, byte[] pin) {
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (WormStore wormStore = new WormStore(mountPoint);){
                if (wormStore.info().initializationState() == WormInitializationState.WORM_INIT_INITIALIZED) {
                    logger.log0("Trying to log in before self test");
                    wormStore.user_login(WormUserId.WORM_USER_ADMIN, pin);
                    wormStore.tse_registerClient(clientid);
                } else if (wormStore.info().initializationState() == WormInitializationState.WORM_INIT_UNINITIALIZED) {
                    logger.log0("Login not tried because initialization state is 'uninitialized'");
                } else if (wormStore.info().initializationState() == WormInitializationState.WORM_INIT_DECOMMISSIONED) {
                    logger.log0("Login not tried because initialization state is 'decommissioned'");
                } else {
                    logger.log0("Login not tried, because initialization state is not initialized");
                }
                logger.log0("Start Self Test");
                wormStore.tse_runSelfTest(clientid);
                logger.log0("Completed Self Test");
                return new CommandResult(true, "Self Test completed");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            logger.log0("Trying to do self test without admin login and registering client");
            logger.log0("Start Self Test");
            try {
                Throwable throwable = null;
                Object var8_15 = null;
                try (WormStore wormStore = new WormStore(mountPoint);){
                    wormStore.tse_runSelfTest(clientid);
                    logger.log0("Completed Self Test");
                    return new CommandResult(true, "Self Test completed");
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (Throwable e2) {
                return new CommandResult(false, "Self test Exception: " + e2.getMessage());
            }
        }
    }

    public static synchronized CommandResult decom(String mountPoint, String clientid, TseConnectorLog logger) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (WormStore wormStore = new WormStore(mountPoint);){
                TseCmdExecutor.completeUnfinishedTransactions(wormStore, clientid, logger, 0);
                logger.log0("Start Decom");
                wormStore.tse_decommission();
                logger.log0("Completed Decom");
                return new CommandResult(true, "Decommission completed");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            return new CommandResult(false, "SDecom Exception: " + e.getMessage());
        }
    }

    public static CommandResult completeUnfinishedTransactions(WormStore wormStore, String clientid, TseConnectorLog logger, int attempt) {
        if (attempt > 2) {
            return new CommandResult(false, "Cannot complete all unfinished transactions");
        }
        try {
            long[] transNumbers = wormStore.transaction_listStartedTransactions(clientid);
            if (transNumbers.length == 0) {
                return new CommandResult(true, "No unfinished transactions");
            }
            int i = 0;
            while (i < transNumbers.length) {
                logger.log0("There was an unfinished transaction " + transNumbers[i] + ". Will be completed now");
                wormStore.transaction_finish(clientid, transNumbers[i], "End".getBytes(StandardCharsets.UTF_8), "Complete unfinished transaction");
                ++i;
            }
            return new CommandResult(true, "Finished " + transNumbers.length + " transactions");
        }
        catch (Throwable e) {
            logger.log0("Start Self Test");
            wormStore.tse_runSelfTest(clientid);
            logger.log0("Completed Self Test");
            return TseCmdExecutor.completeUnfinishedTransactions(wormStore, clientid, logger, attempt + 1);
        }
    }
}

