/*
 * Decompiled with CFR 0.152.
 */
package tseconnector.commands.sim;

import java.time.Instant;
import tseconnector.ITseStatus;
import tseconnector.commands.CommandResult;
import tseconnector.commands.ITseCommand;
import tseconnector.gen.GeneralTseCommand;

public class BaseTseCommandSimulation
extends GeneralTseCommand
implements ITseCommand {
    protected CommandResult makeTseReady(ITseStatus tseStatus) {
        if (!tseStatus.getLastCheckResult()) {
            return new CommandResult(false, "Last TSE check was not successful");
        }
        if (!tseStatus.isTseTimeSet()) {
            CommandResult resultOfUpdateTime = this.updateTime();
            if (resultOfUpdateTime.isOk()) {
                tseStatus.setTseTimeSet(true);
            } else {
                tseStatus.setTseTimeSet(false);
                return new CommandResult(false, "Time could not be set");
            }
        }
        return new CommandResult(true, "");
    }

    protected CommandResult updateTime() {
        long unixTime = Instant.now().getEpochSecond();
        logger.log2("Start Update Time with unixTime " + unixTime);
        logger.log2("Logged in");
        logger.log2("Completed Update Time at TSE");
        return new CommandResult(true, "Completed Update Time at TSE");
    }

    protected static String bytesToHex(byte[] bytes) {
        char[] hexArray = "0123456789ABCDEF".toCharArray();
        char[] hexChars = new char[bytes.length * 2];
        int j = 0;
        while (j < bytes.length) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
            ++j;
        }
        return new String(hexChars);
    }
}

