/*
 * Decompiled with CFR 0.152.
 */
package tseconnector.commands.sim;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.secureflashcard.wormapi.WormError;
import com.secureflashcard.wormapi.WormException;
import com.secureflashcard.wormapi.WormInitializationState;
import com.sun.net.httpserver.HttpExchange;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import tseconnector.ITseStatus;
import tseconnector.commands.BaseTseCommand;
import tseconnector.commands.CommandResult;

public class TseAdminCommandSimulation
extends BaseTseCommand {
    public byte[] puk;
    @JsonIgnore
    public static String correctPass = "";
    @JsonIgnore
    private final String credseed = "SwissbitSwissbit";

    public String toString() {
        return "Tsecmd [pass=" + this.pass + ", pin=" + Arrays.toString(this.pin) + ", puk=" + Arrays.toString(this.puk) + ", cmd=" + this.cmd + "]";
    }

    @Override
    public CommandResult doCmd(ITseStatus tseStatus) {
        if (this.cmd.compareTo("factory_reset") == 0) {
            return this.setup(true);
        }
        if (this.cmd.compareTo("setup") == 0) {
            return this.setup(false);
        }
        if (this.cmd.compareTo("getinfo") == 0) {
            return this.infoTask();
        }
        if (this.cmd.compareTo("decom") == 0) {
            return this.decom();
        }
        if (this.cmd.compareTo("exportdownload") == 0) {
            return this.exportdownload(this.t);
        }
        if (this.cmd.compareTo("exportlocal") == 0) {
            return this.export_to_local_tmp(tseStatus);
        }
        if (this.cmd.compareTo("exportdemodownload") == 0) {
            return this.exportdownload(this.t);
        }
        if (this.cmd.compareTo("forceselftest") == 0) {
            return this.selftest(tseStatus, true);
        }
        if (this.cmd.compareTo("selftest") == 0) {
            return this.selftest(tseStatus, false);
        }
        if (this.cmd.compareTo("getlog") == 0) {
            return TseAdminCommandSimulation.getlog();
        }
        if (this.cmd.compareTo("check") == 0) {
            return TseAdminCommandSimulation.check(tseStatus);
        }
        if (this.cmd.compareTo("userunblock") == 0) {
            return this.userunblock(tseStatus);
        }
        return new CommandResult(false, "No valid command sent: " + this.cmd);
    }

    private CommandResult selftest(ITseStatus tseStatus, boolean force) {
        logger.log0("Start Self Test");
        logger.log0("Completed Self Test");
        return new CommandResult(true, "Self Test completed");
    }

    public CommandResult decom() {
        logger.log0("Start Decom");
        logger.log0("Completed Decom");
        return new CommandResult(true, "Decommission completed");
    }

    private CommandResult userunblock(ITseStatus tseStatus) {
        logger.log2("Simulate start userunblock");
        logger.log2("Simulate completed userunblock");
        return new CommandResult(true, "User unblocked");
    }

    public CommandResult setup(boolean includeFactoryReset) {
        String out = this.setupTask(includeFactoryReset) + "\n";
        logger.log2("Start InfoTask");
        out = String.valueOf(out) + "Info...\n";
        logger.log2("Completed InfoTask. Out=" + out);
        return new CommandResult(true, out);
    }

    private CommandResult setupTask(boolean includeFactoryReset) {
        String log = "";
        log = includeFactoryReset ? String.valueOf(log) + "Factory Reset done. " : String.valueOf(log) + "No factory reset done. ";
        try {
            logger.log0("Start Self Test");
            logger.log0("Completed Self Test");
            log = String.valueOf(log) + "Self Test completed. ";
        }
        catch (WormException e) {
            if (e.error() != WormError.WORM_ERROR_CLIENT_NOT_REGISTERED) {
                throw e;
            }
            WormInitializationState initState = WormInitializationState.WORM_INIT_UNINITIALIZED;
            log = String.valueOf(log) + "Init state = " + initState.toString() + ".";
            if (initState == WormInitializationState.WORM_INIT_UNINITIALIZED) {
                logger.log0("Start Setup");
                logger.log0("Completed Setup");
                log = String.valueOf(log) + "Setup completed. ";
            }
            logger.log2("TSE was already intialized - setup not done");
            log = String.valueOf(log) + "TSE was already intialized - setup not done";
            return new CommandResult(true, log);
        }
        System.out.println("Start Login");
        System.out.println("Logged in");
        log = String.valueOf(log) + "Time updated";
        return new CommandResult(true, log);
    }

    private CommandResult infoTask() {
        long remainingSignatures = 3L;
        String remainingSignaturesTxt = "Anzahl verbleibender Signaturen: " + remainingSignatures;
        if (remainingSignatures < 1L) {
            remainingSignaturesTxt = String.valueOf(remainingSignaturesTxt) + " (TSE auswechseln!)";
        }
        long timestamp = System.currentTimeMillis() / 1000L;
        long certExpirationDate = timestamp + 20L;
        String certValidTxt = "";
        if (certExpirationDate <= timestamp) {
            certValidTxt = "Zertifikat ist abgelaufen! TSE auswechseln!\n";
        }
        String result = "\n\nHINWEIS:\nDas sind nur statische Demo-Werte. Sie stammen nicht von einer echten TSE!!!\n\n";
        result = String.valueOf(result) + "TseDescription: BSI-K-TR-0362\n";
        result = String.valueOf(result) + "Serial Number: 7F5B69CC5E41C803F17242DAC2B3664D33FC2C1039FE892AB0B1D81FF695A7BA\n";
        result = String.valueOf(result) + "Hardware Version: 65538\n";
        result = String.valueOf(result) + "Size: 24\n";
        result = String.valueOf(result) + "Tar Export Size: 13312\n";
        result = String.valueOf(result) + "Public Key: 0456BBD8B2C11063B9C9C16B68EB9B3F8F7502E1279DA8A4909AADF4270220C573CB175B47E3BB7F541806CA17E33BAECF23823E12AFA210B09BA3AB26E8DE8A665054BA94B188FA29287F4B4EDBAB167A77FE67A442849B1F69351CB46F5A903A\n";
        result = String.valueOf(result) + "certificateExpirationDate: 2026-05-29 01:59:59\n";
        result = String.valueOf(result) + "Created Signatures: 892\n";
        result = String.valueOf(result) + "hasValidTime: true";
        result = String.valueOf(result) + "Worm State: TSE is initialized\n";
        result = String.valueOf(result) + "IsCtssInterfaceActive = true\n";
        result = String.valueOf(result) + "HasChangedAdminPin = true\n";
        result = String.valueOf(result) + "HadChangedTimeAdminPin = true\n";
        result = String.valueOf(result) + "HasChangedPUK = true\n";
        result = String.valueOf(result) + "IsDeveloppmentFirmware = false\n";
        result = String.valueOf(result) + "Software version = 65538\n";
        result = String.valueOf(result) + "Needs replacement = false\n";
        result = String.valueOf(result) + "CustomizationIdentifier = 474D4953\n";
        result = String.valueOf(result) + "Form Factor of TSE=SD\n";
        result = String.valueOf(result) + remainingSignaturesTxt + "\n";
        result = String.valueOf(result) + certValidTxt;
        return new CommandResult(true, result);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CommandResult export_to_local_tmp(ITseStatus tseStatus) {
        block17: {
            if (tseStatus.isBusy()) {
                return new CommandResult(false, "TSE is busy");
            }
            tseStatus.setIsBusy(true);
            String exportFile = tseStatus.getTarExportFile();
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try {
                    FileInputStream inputStream = new FileInputStream("src/tseconnector/commands/sim/tse-export-sample.tar");
                    try {
                        try (FileOutputStream output = new FileOutputStream(exportFile, true);){
                            int byteRead;
                            while ((byteRead = ((InputStream)inputStream).read()) != -1) {
                                output.write(byteRead);
                            }
                        }
                        if (inputStream == null) break block17;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (inputStream == null) throw throwable;
                        ((InputStream)inputStream).close();
                        throw throwable;
                    }
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return new CommandResult(false, "Export failed: " + ex.getMessage());
            }
        }
        tseStatus.setIsBusy(false);
        return new CommandResult(true, "Export completed");
    }

    /*
     * Exception decompiling
     */
    private CommandResult exportdownload(HttpExchange t) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[DOLOOP]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static CommandResult getlog() {
        return new CommandResult(true, logger.output(false));
    }

    private static CommandResult check(ITseStatus tseStatus) {
        if (!tseStatus.isCheckUseful()) {
            return new CommandResult(true, "OK");
        }
        if (tseStatus.isBusy()) {
            return new CommandResult(false, "TSE is busy");
        }
        tseStatus.setIsBusy(true);
        logger.log2("Check for TSE Status and availability");
        logger.log0("Simuliere Self Test");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        logger.log0("Beende Simulation Self Test");
        tseStatus.setTseTimeSet(true);
        tseStatus.setIsBusy(false);
        tseStatus.setLastCheckResult(true);
        tseStatus.setSuccessfulCheckIsDone();
        return new CommandResult(true, "OK");
    }
}

