/*
 * Decompiled with CFR 0.152.
 */
package tseconnector.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Base64;
import tseconnector.ITseStatus;
import tseconnector.TseConnectorLog;
import tseconnector.commands.CommandResult;
import tseconnector.commands.ITseCommand;
import tseconnector.commands.TseAdminCommand;
import tseconnector.commands.TseSignCommand;
import tseconnector.commands.sim.TseAdminCommandSimulation;
import tseconnector.commands.sim.TseSignCommandSimulation;
import tseconnector.tseconnector;

public class RequestHandler
implements HttpHandler {
    protected ITseStatus tseStatus = null;
    protected TseConnectorLog logger = null;
    private String correctPass = "";
    private String mountPoint;
    private String mode;

    private RequestHandler() {
    }

    public RequestHandler(String correctPass, ITseStatus tseStatus, String mountPoint, TseConnectorLog logger, String mode) {
        this.correctPass = correctPass;
        this.tseStatus = tseStatus;
        this.logger = logger;
        this.mountPoint = mountPoint;
        this.mode = mode;
    }

    @Override
    public void handle(HttpExchange t) throws IOException {
        try {
            String response = "";
            String contentInJson = this.postDataFromRequest(t);
            ITseCommand cmd = this.parseInput(contentInJson, this.mode, t);
            if (cmd.getPass().compareTo(this.correctPass) != 0) {
                CommandResult error = new CommandResult(false, "Falsches Passwort");
                response = error.resultToTransmit();
            } else {
                cmd.setMountPoint(this.mountPoint);
                CommandResult res = cmd.doCmd(this.tseStatus);
                response = res.resultToTransmit();
            }
            if (cmd.getCmd().compareTo("exportdownload") != 0) {
                this.sendToClient(t, response);
            }
        }
        catch (Exception e) {
            this.logger.log0("Handle Request fehlgeschlagen: " + e.getMessage());
            e.printStackTrace();
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            try {
                CommandResult failedResult = new CommandResult(false, sw.toString());
                this.sendToClient(t, failedResult.resultToTransmit());
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    protected String postDataFromRequest(HttpExchange t) throws IOException {
        int i;
        StringBuilder sb = new StringBuilder();
        InputStream ios = t.getRequestBody();
        while ((i = ios.read()) != -1) {
            sb.append((char)i);
        }
        String sbStr = sb.toString();
        String[] contentParts = sbStr.split("=", 2);
        String content = contentParts[1];
        content = content.replaceAll("%3D", "=");
        byte[] contentBase64Decoded = Base64.getDecoder().decode(content);
        String contentInJson = new String(contentBase64Decoded);
        this.logger.log2("Transferred POST-Data: " + contentInJson);
        return contentInJson;
    }

    protected void sendToClient(HttpExchange t, String response) throws Exception {
        t.sendResponseHeaders(200, response.length());
        OutputStream os = t.getResponseBody();
        os.write(response.getBytes());
        os.close();
    }

    protected ITseCommand parseInput(String httpRequest, String classToInstanciate, HttpExchange t) {
        ITseCommand tsecmd = null;
        ObjectMapper mapper = null;
        try {
            mapper = new ObjectMapper();
        }
        catch (Exception e1) {
            System.err.println("Object Mapper could not be instantiated!");
            e1.printStackTrace();
        }
        try {
            if (classToInstanciate.compareTo("admin") == 0) {
                tsecmd = this.tseStatus.getMode() == tseconnector.Mode.Normal ? (ITseCommand)mapper.readValue(httpRequest, TseAdminCommand.class) : (ITseCommand)mapper.readValue(httpRequest, TseAdminCommandSimulation.class);
                tsecmd.setHttpExchange(t);
            } else {
                tsecmd = this.tseStatus.getMode() == tseconnector.Mode.Normal ? (ITseCommand)mapper.readValue(httpRequest, TseSignCommand.class) : (ITseCommand)mapper.readValue(httpRequest, TseSignCommandSimulation.class);
            }
            tsecmd.setLogger(this.logger);
        }
        catch (IOException e) {
            System.err.println("Impossible to parse httpRequest:");
            e.printStackTrace();
        }
        return tsecmd;
    }
}

