<?php

require_once ('config.php');

class DbUtils {
        public static function openDbAndReturnPdoStatic() {
		$dsn = 'mysql:host=' . MYSQL_HOST . ';dbname=' . MYSQL_DB;
		$user = MYSQL_USER;
		$password = MYSQL_PASSWORD;
		$pdo = null;
		try {
			$pdo = new PDO($dsn, $user, $password);
			$pdo ->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		}
		catch (PDOException $e) {
                        error_log("Connection failed: " . $e->getMessage());
		}
		return $pdo;
	}

        public static function doesTableExist($pdo,string $tablename): bool {
                $sql = "SELECT TABLE_SCHEMA,TABLE_NAME,TABLE_TYPE FROM information_schema.TABLES WHERE
                     TABLE_SCHEMA = '" . MYSQL_DB . "' AND TABLE_NAME = '$tablename'";
                $res = self::fetchSqlAll($pdo, $sql, null);
                if (count($res) == 0) {
                        return false;
                } else {
                        return true;
                }
        }
	
	public static function substTableAlias($sqlString) {
		$out = str_replace("%ebons%",TAB_PREFIX . 'ebons',$sqlString);
		return $out;	
	}
        
        public static function execSql($pdo,$sql,$params) {
		$stmt = $pdo->prepare(self::substTableAlias($sql));
		if (is_null($params)) {
			$stmt->execute();
		} else {
			$stmt->execute($params);
		}
		
	}
        
        public static function fetchSqlAll($pdo,$sql,$params) {
		$stmt = $pdo->prepare(self::substTableAlias($sql));
		if (is_null($params)) {
			$stmt->execute();
		} else {
			$stmt->execute($params);
		}
		return ($stmt->fetchAll(PDO::FETCH_ASSOC));
	}
}