<?php

require_once ('config.php');
require_once ('dbutils.php');

class EbonProvider {
        public static function getEbon(string $ref) {
                try {
                        $pdo = DbUtils::openDbAndReturnPdoStatic();
                        if (is_null($pdo)) {
                                error_log("PDO not established");
                                return false;
                        }
                        if (!DbUtils::doesTableExist($pdo, '%ebons%')) {
                                return "eBon-Datenbank steht nicht zur Verfügung";
                        }
                        $sql = "SELECT billdate,data FROM %ebons% WHERE ebonref=?";
                        $res = DbUtils::fetchSqlAll($pdo, $sql, array($ref));
                        if (count($res) == 1) {
                                return $res[0]["data"];
                        } else {
                                error_log("eBon database has " . count($ref) . " entries for ebon reference $ref");
                                return "eBon-Datenbank hat inkonsistenten Inhalt";
                        }
                } catch (Exception $ex) {
                        error_log("Ebon component could not access database or table: " . $ex->getMessage());
                        return "eBon-System steht nicht zur Verfügung";
                }
        }
}
