<?php

require_once 'dbutils.php';
require_once 'config.php';
defined('DB') || define ( 'DB','mysql' );

class Menu {
        
        private static function getMenuItem($pdo,$item) {
                $entryJson = DbUtils::getConfigItem($pdo, $item, null);
                if (is_null($entryJson)) {
			return null;
		} else {
                        return json_decode($entryJson, true);
                }
        }
	public static function getmenu($pdo) {
                $products = self::getMenuItem($pdo, 'products');
                $types = self::getMenuItem($pdo, 'types');
                $extras = self::getMenuItem($pdo, 'extras');
                
                if (is_null($products) || is_null($types) || is_null($extras)) {
                        return array("status" => "ERROR","msg" => "Keine sinnvolle Produktdefinition hinterlegt.");
                }

		foreach ($types as &$t) {
			$typeid = $t["id"];
			$t["hasprodimages"] = self::hasTypeProdImages($pdo, $products, $typeid);
		}
		
		return array("status" => "OK","msg" => array("types" => $types,"products" => $products,"extras" => $extras));
	}
	
	private static function hasTypeProdImages($pdo,$allproducts,$typeid) {
		$prodids = array();
		foreach($allproducts as $p) {
			if ($p["ref"] == $typeid) {
				$prodids[] = $p["id"];
			}
		}
		$sql = "SELECT COALESCE(content,'') as content FROM %images% WHERE contenttype=? AND productid=?";
		foreach($prodids as $prodid) {
			$img = DbUtils::getImageData($pdo, '', $prodid);
			if (!is_null($img)) {
				return 1;
			}
		}
		return 0;
	}
	
}

if (isset($_GET["command"])) {
	$command = $_GET["command"];
	
	$pdo = null;
	if (DB == "mysql") {
		$pdo = DbUtils::openDbAndReturnPdoStatic();
	}
	
	switch ($command) {
		case "getmenu":
			$ret = Menu::getmenu($pdo);
			echo json_encode($ret);
			break;
		default:
			break;
	}
}

