<?php

require_once 'dbutils.php';
require_once 'config.php';
require_once 'utils/IQueueStorage.php';
require_once 'utils/QueueStorageMySql.php';
require_once 'utils/QueueStorageFile.php';
defined('DB') || define ( 'DB','mysql' );
require_once 'ossystem.php';

class Queue {
	public function putintoqueue(string $timezone,IQueueStorage $storage, string $ordertime,string $tableid,string $tablecode,string $dailycode,array $orders) {                
		date_default_timezone_set($timezone);
		$ordertime = date('Y-m-d H:i:s');
                
                $storage->begin();
                $storage->precheck();
                
                foreach($orders as $anOrder) {
                        $extrasInJson = $this->getExtrasInJson($anOrder);
                        $isOk = $storage->addOrderIntoDb($ordertime,$anOrder,$extrasInJson,$tableid,$tablecode,$dailycode);
                        if (!$isOk) {
                                return array("status" => "ERROR","msg" => "Bestellung nicht speicherbar");
                        }
                }
                $storage->complete();
                return array("status" => "OK");
	}
        
        private function getExtrasInJson($anOrder) {
                if (isset($anOrder["extras"])) {
                        $extras = $anOrder["extras"];
                        $extrasInJson = json_encode($extras);
                        if (strlen($extrasInJson) > 500) {
                                $extrasInJson = '';
                        }
                } else {
                        $extrasInJson = '';
                }
                return $extrasInJson;
        }
}


if (isset($_GET["command"])) {
	$command = $_GET["command"];
	
	if (DB == "mysql") {
                $pdo = DbUtils::openDbAndReturnPdoStatic();
		$timezone = DbUtils::getConfigItem($pdo, "timezone", "Europe/Berlin");
                $pdo = null;
                $storage = new QueueStorageMySql();
	} else {
                $timezone = DbUtils::getConfigItem(null, "timezone", "Europe/Berlin");
                $storage = new QueueStorageFile();
        }
        
	switch ($command) {
		case "putintoqueue":
			$ret = (new Queue())->putintoqueue($timezone,$storage,$_POST["ordertime"],$_POST["tableid"],$_POST["tablecode"],$_POST["dailycode"],$_POST["orders"]);
			echo json_encode($ret);
			break;

		default:
			break;
	}
}