<?php

require_once __DIR__ . '/IQueueStorage.php';

class QueueStorageMySql implements IQueueStorage {
        
        private $pdo;
        
        public function __construct() {
                $this->pdo = DbUtils::openDbAndReturnPdoStatic();
        }

        public function precheck() {
                DbUtils::createColInMySqlTableIfNotExists($this->pdo, "queue", "extrasinjson");
        }
        
        public function addOrderIntoDb(string $ordertime,array $anOrder,string $extrasInJson,string $tableid,?string $tablecode,?string $dailycode) : bool {
                try {
                        $prodid = $anOrder["prodid"];
                        $sql = "INSERT INTO %queue% (date,prodid,tableid,tablecode,dailycode,extrasinjson) VALUES(?,?,?,?,?,?)";
                        DbUtils::execSql($this->pdo, $sql, array($ordertime,$prodid,$tableid,$tablecode,$dailycode,$extrasInJson));
                        DbUtils::log("Added product with id $prodid to mysql queue table");
                        return true;
                } catch (Exception $ex) {
                        error_log("Writing into queue db failed: " . $ex->getMessage());
                        return false;
                }
        }

        public function begin() {
                $this->pdo->beginTransaction();
        }
        
        public function complete() {
                $this->pdo->commit();
        }
}
