##########################################################
#
# PowerShell-Skript für die Datensicherung unter Windows
#
##########################################################

#
# Einstellungen, die der Benutzer anpassen muss:
#

$fernzugriffscode = "123"
$serverurl = "http://localhost"
$zielverzeichnis = "C:\Temp"
$vorhaltezeitInTagen = 2

# --------------------------------------------------------------

#
# Aenderungen ab hier nur noch fuer Experten:
#

$datetime = Get-Date -Format "dddd_dd_MM_yyyy_HH_mm"
$url = "${serverurl}/php/contenthandler.php?module=admin&command=autobackup"
$destfile = "backup_${datetime}.osb"
$destination = "${zielverzeichnis}\${destfile}"
$body = @{
    "remoteaccesscode" ="${fernzugriffscode}"
}
Invoke-WebRequest -Method 'Post' -Uri $url -Body ($body) -OutFile $destination

Get-ChildItem -Path $zielverzeichnis -Recurse | Where-Object {($_.LastWriteTime -lt (Get-Date).AddDays(-${vorhaltezeitInTagen}))} | Remove-Item
