/**
 * Set of clients
 */

function ClientSet () {
	//this.clients = clients;
}

ClientSet.overviewHtmlFieldId = "";
ClientSet.clients = [];

ClientSet.readAllClientsFromDb = function(htmlFieldId) {
	ClientSet.overviewHtmlFieldId = htmlFieldId;
	doAjax("POST","php/clients.php?command=getallclients",null,ClientSet.fillclientset,"Kommunikationsfehler");
}

/**
 * Return the array of all clients that have been read from the database, take care not
 * to return the placeholder for a new instance!
 * 
 * @returns {Array}
 */
ClientSet.getAllReadClients = function() {
	var existingClients = [];
	ClientSet.clients.forEach(function(entry) {
		if (entry.id != "new") {
			existingClients[existingClients.length] = entry;
		}
	});
	return existingClients;
}
/**
 * Use the given client parameter information to fill up the web ui
 * @param clients
 */
ClientSet.fillclientset = function(clients) {
	ClientSet.clients = [];
	for (var i=0;i<clients.length;i++) {
		var aClient = clients[i];
		// id,name,url,remoteaccesscode,basicAuthUser,basicAuthPassword,remark
		ClientSet.clients[ClientSet.clients.length] = new Client(aClient.id,aClient.name,aClient.url,aClient.remoteaccesscode,aClient.basicauthuser,aClient.basicauthpass,aClient.remark);
	}
	
	// now add an empty entry for a "new" client
	ClientSet.clients[ClientSet.clients.length] = new Client("new","Name3","http://","Fernzugang","BasicAuthUser","BasicAuthPassword","Bemerkung3");
	$(ClientSet.overviewHtmlFieldId).html(ClientSet.getTableOfAllClients());
	ClientSet.bindActionsOfAllClients();
	ClientSet.bindRateSelection();
}

ClientSet.bindRateSelection = function() {
	$('#refreshselection').change(function() {	
		var rate = $( "#refreshselection option:selected" ).val();
		var data = { rate: rate};
		doAjax("POST","php/generals.php?command=setrate",data,ClientSet.reloadOverviewPage,null);
 	});
}

ClientSet.reloadOverviewPage = function() {
	reloadPage("overview.php");
};


/**
 * Table th-headers that describe the content of the columns for the clients parameters
 * @returns {String} html string
 */
ClientSet.getHeader = function() {
	return "<tr><th>Name<th>Internetadresse<th>Fernzugangscode<th>Basic Authentication Benutzer<th>Basic Authentication Passwort<th>Bemerkung<th>Aktionen</tr>";
};

/**
 * Get the full clients parameters table of all clients
 * 
 * @returns {String} the html string
 */
ClientSet.getTableOfAllClients = function() {
	var txt = "<form><table class=gentable>" + this.getHeader();
	var i=0;
	for (i=0;i<ClientSet.clients.length;i++) {
		var aClient = this.clients[i];
		txt += aClient.showSettings();
	}
	txt += "</table></form>";
	return txt;
};

/**
 * Bind the action buttons (create new client, delete or change clients settings) to the 
 * functions that are responsible for its execution.
 * This function does this for all clients in the set. It must be called
 * after the rendering in the user interface!
 */
ClientSet.bindActionsOfAllClients = function() {
	var txt = "<form><table class=gentable>" + this.getHeader();
	var i=0;
	for (i=0;i<ClientSet.clients.length;i++) {
		var aClient = ClientSet.clients[i];
		aClient.handleactions();
	}
};

/**
 * Read the parameters of all clients and show the parameter list in the html element
 * with the given id.
 */
function showClient() {
	ClientSet.readAllClientsFromDb("#clientoverviewlist");
}

/**
 * Bindings for buttons that work on the complete set of clients, e.g. backup
 */
function bindClientSetManageFunctions() {
	$("#backup_btn").on("click", function (e) {
 		e.stopImmediatePropagation();
 		e.preventDefault();
		window.location.href = "php/clients.php?command=saveclients";
	});
}