<html>

<head>
    <title>OrderSprinter Spider</title>
    <meta http-equiv="content-type" content="text/html; charset=utf-8">
    <link rel="stylesheet" type="text/css" href="styles/spider.css">
    <link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">
    <script src="3rdparty/jquery-2.0.3.min.js"></script>
	<script src="//code.jquery.com/ui/1.11.4/jquery-ui.js"></script>
    <script src="utils.js"></script>
    <script src="js/client.js"></script>
    <script src="js/clientset.js"></script>
    <script src="js/clientinfo.js"></script>
    <script src="js/clientdetails.js"></script>
</head>

<body>

<!-- define style here because they are specific to this page and too late in spider.css -->
<style>
.ui-tabs .clientconfig {
    background: Khaki;
}
.ui-tabs .clientinfo {
    background: #ffd3af;
}
.ui-tabs .clientdetails {
    background: DarkKhaki;
}
</style>
<script>


/**
 * If the user is logged the overview shall be displayed. Otherwise forward to login page.
 */
function handleLoginStatus(isLoggedIn) {
 	if (isLoggedIn == "YES") {
 		// show overview
 		showClient();
 	} else {
 		// user needs to log in -> forward to entry page
 		setTimeout(function(){document.location.href = "index.html"},250);
 	}
}

function checkIntervalLoginStatus() {
    var refreshId = setInterval(function() {
		doAjaxTransmitValue("POST","php/datacollector.php?command=isloggedin",null,handleIsLoggedIn,null,null);
	 }, 5000);
}

function handleIsLoggedIn(answer) {
	if (answer !== "YES") {
		setTimeout(function(){document.location.href = "index.html"},500);
	}
}


function refreshClientInfo() {
	ClientInfo.showInfoOfAllClients(ClientSet.getAllReadClients(),"#clientinfos");
}

function handleRefreshRate(rateinfo) {
	var refreshRate = 1; // default: 1 time / hour
	if (rateinfo.status[0] == 1) {
		refreshRate = parseInt(rateinfo.rate);
	}
	$("#refreshselection").val(refreshRate);
	// update information in intervals
 	var refreshId = setInterval(function() {
 		refreshClientInfo();
 		ClientDetails.updateReport();
 	 }, 3600000/refreshRate);
}

/**
 * This is the first script entry for jQuery enabled sites.
 */
$( document ).ready(function() {
	$.ajaxSetup({ cache: false });
	
	doAjax("GET","php/generals.php?command=getSpiderVersion",null,insertSpiderVersion,null);
	doAjax("POST","php/generals.php?command=isUserLoggedIn",null,handleLoginStatus,null);
	
	bindLogout();
 	bindClientSetManageFunctions();
 	
 	$("#tabs").tabs();
 	$('#tabs .ui-tabs-nav a[href="#tabs-1"], #tabs-1').addClass('clientconfig');
 	$('#tabs .ui-tabs-nav a[href="#tabs-2"], #tabs-2').addClass('clientinfo');
 	$('#tabs .ui-tabs-nav a[href="#tabs-3"], #tabs-3').addClass('clientdetails');
 	
 	
 	// initialize tables
 	refreshClientInfo();
 	
 	// insert a selection box of clients for detailed view
 	ClientDetails.createSelectionBox(ClientSet.getAllReadClients(),"#clientselection");
 	
	// fetch the value by which the data shall be refreshed
 	doAjax("GET","php/generals.php?command=getrate",null,handleRefreshRate,null);
 	
 	checkIntervalLoginStatus();
});

</script>

<table border=0>
<tr><td><img src=img/spider-logo-30s.png />
<td><h1>Übersicht über alle Betriebe</h1>
</tr></table>

<div id="tabs">
  <ul>
    <li><a href="#tabs-1" class="clientconfig">Betriebe festlegen</a></li>
    <li><a href="#tabs-2">Übersicht</a></li>
    <li><a href="#tabs-3">Detailansicht</a></li>
  </ul>
  <div id="tabs-1">
  	<p>
		
  		<div id=clientoviewarea>
			<?php include ("clientset.html"); ?>
		</div> <!-- Area with list of all clients and the buttons to manage the set -->
	</p>
  </div>
  <div id="tabs-2">
	  <p>
	  	<div id=clientinfos></div>
	  </p>
  </div>
  <div id="tabs-3">
  	
	  <div id="clientsdetailsarea">
		  <?php include ("clientdetails.html"); ?>
	  </div>
  </div>
</div>


<div id=logoutsection class="gentable">
	<form>
		<input type="submit" style="width:100%;height:70px;" value="Ausloggen" id="logoutbtn"/>
	</form>
</div>

<br>
<div><i>OrderSprinter Spider - Version <span id=spiderversion></span></i></div>
</body>

</html>

