/*
 * Decompiled with CFR 0.152.
 */
package javaprinter.customreceipt;

import java.util.ArrayList;
import java.util.List;
import javaprinter.customreceipt.Layoutfield;
import javaprinter.customreceipt.TemplateLine;
import javaprinter.genutils.GenUtils;
import javaprinter.json.Config;
import javaprinter.json.IEntry;
import javaprinter.json.IReceipt;

public class CustomReceipt {
    byte[] lf_byte = new byte[]{10};
    byte[] dsizeon = new byte[]{27, 33, 16};
    byte[] dsizedouble = new byte[]{27, 33, 48};
    byte[] dsizeoff;
    private int length;
    private String template;
    private String hosttext;
    private String decpoint;
    private String companyInfo;
    private byte[] logobytes;
    private String currency;

    public CustomReceipt(int length, String template, String hosttext) {
        byte[] byArray = new byte[3];
        byArray[0] = 27;
        byArray[1] = 33;
        this.dsizeoff = byArray;
        this.length = 0;
        this.template = "";
        this.hosttext = "";
        this.decpoint = ",";
        this.companyInfo = "";
        this.logobytes = new byte[0];
        this.currency = "";
        this.length = length;
        this.template = template;
        this.hosttext = hosttext;
    }

    public byte[] createReceipt(Config config, byte[] logobytes, IReceipt receipt) {
        this.companyInfo = config.companyinfo;
        this.decpoint = config.decpoint;
        this.currency = config.currency;
        this.logobytes = logobytes == null ? new byte[0] : logobytes;
        byte[] out = new byte[]{};
        String[] templateLines = (String.valueOf(this.template) + "\n ").split("\n");
        ArrayList<String> iterationLines = null;
        int i = 0;
        boolean eof = false;
        while (!eof) {
            String aLine = templateLines[i];
            String trimmedLine = aLine.trim();
            if (trimmedLine.startsWith("START_")) {
                int pos = trimmedLine.indexOf("_") + 1;
                int length = trimmedLine.length();
                if (length > pos) {
                    String loopKey = trimmedLine.substring(pos, length);
                    String loopUntilStr = "END_" + loopKey;
                    iterationLines = new ArrayList<String>();
                    boolean stopped = false;
                    while (!stopped) {
                        if (++i >= templateLines.length) {
                            stopped = true;
                            continue;
                        }
                        String line = templateLines[i];
                        if (line.startsWith("# ")) continue;
                        if (line.trim().compareTo(loopUntilStr) != 0) {
                            iterationLines.add(line);
                            continue;
                        }
                        stopped = true;
                    }
                    out = GenUtils.MergeArrays(out, this.renderEntriesLoop(iterationLines, receipt, loopKey));
                }
            } else if (!aLine.startsWith("#")) {
                out = GenUtils.MergeArrays(out, this.renderNormalLine(new TemplateLine(aLine), receipt));
            }
            if (++i < templateLines.length) continue;
            eof = true;
        }
        byte[] hostbytes = new byte[]{};
        if (this.hosttext != null && receipt.printHostPart()) {
            String hosttextOnlySlashN = this.hosttext.replaceAll("(\r\n|\n)", "\n");
            hostbytes = GenUtils.str2bytes(hosttextOnlySlashN);
        }
        return GenUtils.MergeArrays(GenUtils.int2byteArray(config.escinits), out, hostbytes, GenUtils.lf_byte, GenUtils.lf_byte, GenUtils.int2byteArray(config.escposts));
    }

    private byte[] renderNormalLine(TemplateLine templateLine, IReceipt receipt) {
        List varLengths = templateLine.calcVariableSpace(this.length);
        return GenUtils.MergeArrays(this.renderSingleContentEntry(templateLine, receipt, varLengths), GenUtils.lf_byte);
    }

    private byte[] renderEntriesLoop(List<String> templateLines, IReceipt receipt, String key) {
        IEntry[] entries = receipt.getLoopEntries(key);
        byte[] out = new byte[]{};
        int i = 0;
        while (i < entries.length) {
            IEntry anEntry = entries[i];
            int lineIndex = 0;
            while (lineIndex < templateLines.size()) {
                TemplateLine templateLine = new TemplateLine(templateLines.get(lineIndex));
                List variableSpaces = templateLine.calcVariableSpace(this.length);
                byte[] linebytes = this.renderSingleLoopEntry(templateLine, anEntry, variableSpaces);
                boolean hasContent = true;
                if (linebytes.length > 0) {
                    hasContent = false;
                    byte[] byArray = linebytes;
                    int n = linebytes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        byte aByte = byArray[n2];
                        if (aByte != 32) {
                            hasContent = true;
                            break;
                        }
                        ++n2;
                    }
                }
                if (hasContent) {
                    out = GenUtils.MergeArrays(out, linebytes, GenUtils.lf_byte);
                }
                ++lineIndex;
            }
            ++i;
        }
        return out;
    }

    private byte[] renderSingleLoopEntry(TemplateLine templateLine, IEntry entry, List variableSpace) {
        byte[] out = new byte[]{};
        int varLengthUsed = 0;
        Layoutfield[] lFields = templateLine.layoutFields;
        int i = 0;
        while (i < lFields.length) {
            Layoutfield field = lFields[i];
            if (field.fieldId.compareToIgnoreCase("RAW") == 0) {
                out = GenUtils.MergeArrays(out, GenUtils.int2byteArray(field.rawbytes));
            } else if (!field.isFixedLength) {
                out = GenUtils.MergeArrays(out, this.renderValue(field, entry, (int)((Integer)variableSpace.get(varLengthUsed))));
                ++varLengthUsed;
            } else {
                out = GenUtils.MergeArrays(out, this.renderValue(field, entry, 0));
            }
            ++i;
        }
        return out;
    }

    private byte[] renderSingleContentEntry(TemplateLine templateLine, IReceipt receipt, List variableSpace) {
        byte[] out = new byte[]{};
        int varLengthUsed = 0;
        Layoutfield[] lFields = templateLine.layoutFields;
        int i = 0;
        while (i < lFields.length) {
            Layoutfield field = lFields[i];
            if (field.fieldId.compareToIgnoreCase("RAW") == 0) {
                out = GenUtils.MergeArrays(out, GenUtils.int2byteArray(field.rawbytes));
            } else if (!field.isFixedLength) {
                out = GenUtils.MergeArrays(out, this.renderValue(field, receipt, (int)((Integer)variableSpace.get(varLengthUsed))));
                ++varLengthUsed;
            } else {
                out = GenUtils.MergeArrays(out, this.renderValue(field, receipt, 0));
            }
            ++i;
        }
        return out;
    }

    private byte[] addTextSizes(Layoutfield field, byte[] txt) {
        if (field.isBold && !field.isWide) {
            txt = GenUtils.MergeArrays(this.dsizeon, txt, this.dsizeoff);
        } else if (field.isBold && field.isWide) {
            txt = GenUtils.MergeArrays(this.dsizedouble, txt, this.dsizeoff);
        } else if (!field.isBold && field.isWide) {
            txt = GenUtils.MergeArrays(this.dsizedouble, txt, this.dsizeoff);
        }
        return txt;
    }

    private byte[] renderValue(Layoutfield field, IReceipt receipt, int variableSpace) {
        String valueStr = "";
        if (field.fieldId.compareToIgnoreCase("RAW") == 0) {
            return GenUtils.int2byteArray(field.rawbytes);
        }
        if (field.fieldId.compareToIgnoreCase("j") == 0) {
            return GenUtils.createNote(this.companyInfo, this.length, true);
        }
        if (field.fieldId.compareToIgnoreCase("l") == 0) {
            return this.logobytes;
        }
        if (field.fieldId.compareToIgnoreCase("s") == 0) {
            valueStr = String.valueOf(valueStr) + field.layoutStr;
        } else {
            if (field.fieldId.compareToIgnoreCase("f") == 0) {
                return this.addTextSizes(field, GenUtils.str2bytes(this.createStr(field.layoutStr, variableSpace)));
            }
            valueStr = String.valueOf(valueStr) + receipt.renderValueAsString(field.fieldId, this.decpoint, this.currency);
        }
        return this.addTextSizes(field, this.renderField(field, valueStr, variableSpace));
    }

    private byte[] renderValue(Layoutfield field, IEntry entry, int variableSpace) {
        String valueStr = "";
        if (field.fieldId.compareToIgnoreCase("RAW") == 0) {
            return GenUtils.int2byteArray(field.rawbytes);
        }
        if (field.fieldId.compareToIgnoreCase("s") == 0) {
            valueStr = field.layoutStr;
        } else {
            if (field.fieldId.compareToIgnoreCase("f") == 0) {
                return this.addTextSizes(field, GenUtils.str2bytes(this.createStr(field.layoutStr, variableSpace)));
            }
            valueStr = entry.renderValueAsString(field.fieldId, this.decpoint, this.currency);
        }
        return this.addTextSizes(field, this.renderField(field, valueStr, variableSpace));
    }

    private String createStr(String s, int length) {
        s = s.substring(0, 1);
        StringBuffer outputBuffer = new StringBuffer(length);
        int i = 0;
        while (i < length) {
            outputBuffer.append(s);
            ++i;
        }
        return outputBuffer.toString();
    }

    private byte[] renderField(Layoutfield field, String value, int variableSpace) {
        String out = "";
        if (field.prefix.length() > 0) {
            value = String.valueOf(field.prefix) + ": " + value;
        }
        int len = field.length;
        if (field.isFixedLength && field.alignment == Layoutfield.RIGHT) {
            out = CustomReceipt.padLeft(value, len);
        } else if (field.isFixedLength && field.alignment == Layoutfield.LEFT) {
            out = CustomReceipt.padRight(value, len);
        } else if (!field.isFixedLength && field.alignment == Layoutfield.LEFT) {
            out = CustomReceipt.padRight(value, variableSpace);
        } else if (!field.isFixedLength && field.alignment == Layoutfield.RIGHT) {
            out = CustomReceipt.padLeft(value, variableSpace);
        }
        byte[] bout = GenUtils.str2bytes(out);
        return bout;
    }

    private static String getSubStr(String text, int maxLength) {
        int max = Math.min(text.length(), maxLength);
        return text.substring(0, max);
    }

    private static String padRight(String s, int n) {
        String out = "";
        String[] parts = s.split("\n");
        if (parts.length > 1) {
            int i = 0;
            while (i < parts.length - 1) {
                String p = CustomReceipt.getSubStr(parts[i], n);
                out = String.valueOf(out) + String.format("%1$-" + n + "s", p) + Character.toString('\n');
                ++i;
            }
            out = String.valueOf(out) + String.format("%1$-" + n + "s", CustomReceipt.getSubStr(parts[parts.length - 1], n));
        } else {
            out = String.format("%1$-" + n + "s", CustomReceipt.getSubStr(s, n));
        }
        return out;
    }

    private static String padLeft(String s, int n) {
        String out = "";
        String[] parts = s.split("\n");
        if (parts.length > 1) {
            int i = 0;
            while (i < parts.length - 1) {
                String p = CustomReceipt.getSubStr(parts[i], n);
                out = String.valueOf(out) + String.format("%1$" + n + "s", p) + Character.toString('\n');
                ++i;
            }
            out = String.valueOf(out) + String.format("%1$" + n + "s", CustomReceipt.getSubStr(parts[parts.length - 1], n));
        } else {
            out = String.format("%1$" + n + "s", CustomReceipt.getSubStr(s, n));
        }
        return out;
    }
}

