/*
 * Decompiled with CFR 0.152.
 */
package javaprinter.json;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import javaprinter.json.ReceiptConfig;

public class Config {
    public int printersize = 30;
    public int useeveryprintdevice = 1;
    public String vendorid = "";
    public String productid = "";
    @JsonIgnore
    public String currency = "Euro";
    @JsonIgnore
    public String decpoint = ",";
    @JsonIgnore
    public String companyinfo = "";
    @JsonIgnore
    public int pollbills = 2;
    @JsonIgnore
    public int pollworksf = 2;
    @JsonIgnore
    public int pollworksd = 2;
    @JsonIgnore
    public int pollclosings = 2;
    @JsonIgnore
    public int pollpickups = 2;
    public int instance = 1;
    public int[] escinits;
    public int[] escposts;
    public String printcode;
    public String baseusername;
    public String basepass;
    public String baseurl = "";
    public int verbose_closing_summary = 1;
    public int smallformat = 0;
    @JsonIgnore
    public byte[] logo = null;
    public double logoscale = 0.5;

    public void readConfig() {
        try {
            ObjectMapper mapper = new ObjectMapper();
            URL url = this.getClass().getResource("../../config.json");
            File file = new File(url.getPath());
            JsonNode root = mapper.readTree(file);
            this.printersize = root.get("printersize").asInt();
            this.vendorid = root.get("vendorid").asText().toLowerCase();
            this.productid = root.get("productid").asText().toLowerCase();
            this.currency = root.get("currency").asText();
            this.decpoint = root.get("decpoint").asText();
            this.companyinfo = root.get("companyinfo").asText();
            this.instance = root.get("instance").asInt();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void insertReceiptConfig(ReceiptConfig rConfig) {
        this.companyinfo = rConfig.companyinfo;
        this.currency = rConfig.currency;
        this.decpoint = rConfig.decpoint;
        this.pollbills = rConfig.pollbills;
        this.pollworksf = rConfig.pollworksf;
        this.pollworksd = rConfig.pollworksd;
        this.pollclosings = rConfig.pollclosings;
        this.pollpickups = rConfig.pollpickups;
    }

    public void insertLogoBytes(byte[] logo) {
        this.logo = logo;
    }

    public String toString() {
        return "Config [printersize=" + this.printersize + ", vendorid=" + this.vendorid + ", productid=" + this.productid + ", currency=" + this.currency + ", decpoint=" + this.decpoint + ", companyinfo=" + this.companyinfo + ", escinits=" + Arrays.toString(this.escinits) + ", escposts=" + Arrays.toString(this.escposts) + ", printcode=" + this.printcode + ", baseurl=" + this.baseurl + ", baseusername=" + this.baseusername + ", basepass=" + this.basepass + ", verbose_closing_summary=" + this.verbose_closing_summary + "]";
    }
}

