/*
 * Decompiled with CFR 0.152.
 */
package tseconnector;

import java.util.ArrayList;
import tseconnector.LogEntry;

public class TseConnectorLog {
    ArrayList<LogEntry> logs = new ArrayList();
    boolean outputToCmd = false;
    private int loglevel = 1;

    public void setLoglevel(int loglevel) {
        this.loglevel = loglevel;
    }

    public TseConnectorLog(boolean stdoutput) {
        this.outputToCmd = stdoutput;
    }

    private void addLog(LogEntry entry) {
        if (this.logs.size() > 2000) {
            this.logs = new ArrayList();
            this.logs.add(new LogEntry("Log truncated due to save memory"));
        }
        this.logs.add(entry);
    }

    public void log0(String msg) {
        LogEntry entry = new LogEntry(msg);
        this.addLog(entry);
        if (this.outputToCmd) {
            System.out.println(entry.toString());
        }
    }

    public void log1(String msg) {
        if (this.loglevel >= 1) {
            LogEntry entry = new LogEntry(msg);
            this.addLog(entry);
            if (this.outputToCmd) {
                System.out.println(entry.toString());
            }
        }
    }

    public void log2(String msg) {
        if (this.loglevel >= 2) {
            LogEntry entry = new LogEntry(msg);
            this.addLog(entry);
            if (this.outputToCmd) {
                System.out.println(entry.toString());
            }
        }
    }

    public String output(boolean isHtml) {
        StringBuffer sb = new StringBuffer();
        if (isHtml) {
            int i = 0;
            while (i < this.logs.size()) {
                sb.append("<span style=\"font-style: italic; color:grey;\">");
                sb.append(this.logs.get(i).getDatetime());
                sb.append(": </span>");
                sb.append("<span style=\"color:black;\">");
                sb.append(this.logs.get(i).getMsg());
                sb.append("</span>");
                sb.append("<br>");
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.logs.size()) {
                sb.append(String.valueOf(this.logs.get(i).toString()) + "\n");
                ++i;
            }
        }
        return sb.toString();
    }
}

