/*
 * Decompiled with CFR 0.152.
 */
package tseconnector;

import java.io.File;
import java.util.ArrayList;
import tseconnector.TseConnectorLog;

public class TseLocator {
    private boolean isWindowsSystem() {
        String osName = System.getProperty("os.name");
        return osName.toLowerCase().startsWith("windows");
    }

    private ArrayList<String> getDirsInPath(String path) {
        File[] directories = new File(path).listFiles(File::isDirectory);
        ArrayList<String> fullPathes = new ArrayList<String>();
        if (directories != null) {
            File[] fileArray = directories;
            int n = directories.length;
            int n2 = 0;
            while (n2 < n) {
                File aDir = fileArray[n2];
                fullPathes.add(aDir.getPath());
                ++n2;
            }
        }
        return fullPathes;
    }

    private boolean checkExistenceOfFile(String path, String fileName) {
        File tempFile = new File(String.valueOf(path) + File.separator + fileName);
        return tempFile.exists();
    }

    private boolean checkForTseDeviceInCertainDir(String path) {
        return this.checkExistenceOfFile(path, "TSE_INFO.DAT") || this.checkExistenceOfFile(path, "tse_info.dat") || this.checkExistenceOfFile(path, "TSE_COMM.DAT") || this.checkExistenceOfFile(path, "tse_comm.dat") || this.checkExistenceOfFile(path, "TSE_TAR.001") || this.checkExistenceOfFile(path, "tse_tar.001");
    }

    private String findTseInLinux() {
        String[] roots;
        String[] stringArray = roots = new String[]{"/mnt", "/mount", "/media"};
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            String aRoot = stringArray[n2];
            ArrayList<String> subdirs = this.getDirsInPath(aRoot);
            for (String aSubdir : subdirs) {
                if (!this.checkForTseDeviceInCertainDir(aSubdir)) continue;
                return aSubdir;
            }
            ++n2;
        }
        return null;
    }

    private String findTseInWindows() {
        File[] drives;
        File[] fileArray = drives = new File[]{new File("/tmp")};
        int n = drives.length;
        int n2 = 0;
        while (n2 < n) {
            File aSubdir = fileArray[n2];
            if (this.checkForTseDeviceInCertainDir(aSubdir.getPath())) {
                return aSubdir.getPath();
            }
            ++n2;
        }
        return null;
    }

    public String findTse() {
        TseConnectorLog logger = new TseConnectorLog(true);
        String aPath = null;
        if (this.isWindowsSystem()) {
            logger.log0("Suche TSE Hardware in Windows-System...");
            aPath = this.findTseInWindows();
        } else {
            logger.log0("Suche TSE Hardware in Linux-Systen...");
            aPath = this.findTseInLinux();
        }
        return aPath;
    }
}

