/*
 * Decompiled with CFR 0.152.
 */
package tseconnector;

import java.time.Instant;
import tseconnector.ITseStatus;
import tseconnector.TseConnectorLog;
import tseconnector.tseconnector;

public class TseStatus
implements ITseStatus {
    private long lastSuccessfulCheck = 0L;
    private long lastTimeSet = 0L;
    private long maxSecondsBetweenTimeUpdates = 0L;
    private int serverPort;
    private boolean isBusy = false;
    private boolean lastCheckResult = true;
    private tseconnector.Mode mode = tseconnector.Mode.Normal;
    private TseConnectorLog logger = null;
    private String tarExportFile = "/tmp/tsetarexport";

    @Override
    public void setLogger(TseConnectorLog logger) {
        this.logger = logger;
    }

    @Override
    public void setServerPort(int port) {
        this.serverPort = port;
    }

    @Override
    public int getServerPort() {
        return this.serverPort;
    }

    @Override
    public void setSyncDurationTime(long durationInSeconds) {
        this.maxSecondsBetweenTimeUpdates = durationInSeconds;
    }

    private void logifpossible_level2(String msg) {
        if (this.logger != null) {
            this.logger.log2(msg);
        }
    }

    @Override
    public boolean isCheckUseful() {
        int tenMinutes;
        long currentTimeStamp = Instant.now().getEpochSecond();
        if (currentTimeStamp - this.lastSuccessfulCheck > (long)(tenMinutes = 1800)) {
            this.logifpossible_level2("isCheckUseful = true: current = " + currentTimeStamp + ", lastSucces=" + this.lastSuccessfulCheck);
            return true;
        }
        this.logifpossible_level2("isCheckUseful = false: current = " + currentTimeStamp + ", lastSucces=" + this.lastSuccessfulCheck);
        return false;
    }

    @Override
    public void setSuccessfulCheckIsDone() {
        this.lastSuccessfulCheck = Instant.now().getEpochSecond();
    }

    @Override
    public boolean isTseTimeSet() {
        long currentTimeStamp = Instant.now().getEpochSecond();
        return currentTimeStamp - this.lastTimeSet <= this.maxSecondsBetweenTimeUpdates;
    }

    @Override
    public void setTseTimeSet(boolean tseTimeSet) {
        this.lastTimeSet = !tseTimeSet ? 0L : Instant.now().getEpochSecond();
    }

    @Override
    public void setMode(tseconnector.Mode mode) {
        this.mode = mode;
    }

    @Override
    public tseconnector.Mode getMode() {
        return this.mode;
    }

    @Override
    public void setIsBusy(boolean isBusy) {
        this.isBusy = isBusy;
    }

    @Override
    public boolean isBusy() {
        return this.isBusy;
    }

    @Override
    public boolean getLastCheckResult() {
        return this.lastCheckResult;
    }

    @Override
    public void setLastCheckResult(boolean lastCheckResult) {
        this.lastCheckResult = lastCheckResult;
    }

    @Override
    public void setTarExportFile(String directory) {
        this.tarExportFile = directory;
    }

    @Override
    public String getTarExportFile() {
        return this.tarExportFile;
    }
}

