/*
 * Decompiled with CFR 0.152.
 */
package tseconnector.commands;

import com.secureflashcard.wormapi.WormAuthenticationFailedException;
import com.secureflashcard.wormapi.WormInitializationState;
import com.secureflashcard.wormapi.WormStore;
import com.secureflashcard.wormapi.WormUserId;
import java.time.Instant;
import tseconnector.ITseStatus;
import tseconnector.commands.CommandResult;
import tseconnector.commands.ITseCommand;
import tseconnector.gen.GeneralTseCommand;

public class BaseTseCommand
extends GeneralTseCommand
implements ITseCommand {
    protected CommandResult makeTseReady(ITseStatus tseStatus) {
        if (!tseStatus.getLastCheckResult()) {
            return new CommandResult(false, "Last TSE check was not successful");
        }
        if (!tseStatus.isTseTimeSet()) {
            CommandResult resultOfUpdateTime = this.updateTime();
            if (resultOfUpdateTime.isOk()) {
                tseStatus.setTseTimeSet(true);
                return this.registerClient(this.clientid);
            }
            tseStatus.setTseTimeSet(false);
            return resultOfUpdateTime;
        }
        return new CommandResult(true, "");
    }

    protected CommandResult registerClient(String clientid) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (WormStore wormStore = new WormStore(this.mountPoint);){
                wormStore.tse_registerClient(clientid);
                return new CommandResult(true, "Completed Register Client with id " + clientid + " at TSE");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            return new CommandResult(false, "Register Client resulted in an exception: " + e.getMessage());
        }
    }

    protected CommandResult updateTime() {
        try {
            Throwable throwable = null;
            Object var2_5 = null;
            try (WormStore wormStore = new WormStore(this.mountPoint);){
                long unixTime = Instant.now().getEpochSecond();
                logger.log2("Start Update Time with unixTime " + unixTime);
                if (wormStore.info().initializationState() != WormInitializationState.WORM_INIT_INITIALIZED) {
                    return new CommandResult(false, "WormStore not initialized - do notrtry to log in. Stopping update time.");
                }
                wormStore.user_login(WormUserId.WORM_USER_ADMIN, this.pin);
                logger.log2("Logged in");
                wormStore.tse_updateTime(unixTime);
                logger.log2("Completed Update Time at TSE");
                return new CommandResult(true, "Completed Update Time at TSE");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (WormAuthenticationFailedException authException) {
            String remainingMsg = "remaining retries = " + authException.remainingRetries;
            String errMsg = authException.getMessage();
            logger.log0("Authentication error: " + errMsg + " - " + remainingMsg);
            return new CommandResult(false, "Authentication issue: " + errMsg + " - " + remainingMsg);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return new CommandResult(false, "Update Time resulted in an exception: " + e.getMessage());
        }
    }

    protected static String bytesToHex(byte[] bytes) {
        char[] hexArray = "0123456789ABCDEF".toCharArray();
        char[] hexChars = new char[bytes.length * 2];
        int j = 0;
        while (j < bytes.length) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
            ++j;
        }
        return new String(hexChars);
    }
}

