/*
 * Decompiled with CFR 0.152.
 */
package tseconnector.commands;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.secureflashcard.wormapi.WormAuthenticationFailedException;
import com.secureflashcard.wormapi.WormError;
import com.secureflashcard.wormapi.WormException;
import com.secureflashcard.wormapi.WormExportTarCallback;
import com.secureflashcard.wormapi.WormInformation;
import com.secureflashcard.wormapi.WormInitializationState;
import com.secureflashcard.wormapi.WormStore;
import com.secureflashcard.wormapi.WormUserId;
import com.sun.net.httpserver.HttpExchange;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Locale;
import tseconnector.ITseStatus;
import tseconnector.commands.BaseTseCommand;
import tseconnector.commands.CommandResult;
import tseconnector.commands.TseCmdExecutor;

public class TseAdminCommand
extends BaseTseCommand {
    public byte[] puk;
    @JsonIgnore
    public static String correctPass = "";
    @JsonIgnore
    private final String credseed = "SwissbitSwissbit";

    public String toString() {
        return "Tsecmd [pass=" + this.pass + ", pin=" + Arrays.toString(this.pin) + ", puk=" + Arrays.toString(this.puk) + ", cmd=" + this.cmd + "]";
    }

    @Override
    public CommandResult doCmd(ITseStatus tseStatus) {
        if (this.cmd.compareTo("factory_reset") == 0) {
            return this.setup(tseStatus, true);
        }
        if (this.cmd.compareTo("setup") == 0) {
            return this.setup(tseStatus, false);
        }
        if (this.cmd.compareTo("getinfo") == 0) {
            return this.infoTask(null);
        }
        if (this.cmd.compareTo("decom") == 0) {
            return this.decom(this.clientid);
        }
        if (this.cmd.compareTo("exportlocal") == 0) {
            return this.export_to_local_tmp(tseStatus);
        }
        if (this.cmd.compareTo("exportdownload") == 0) {
            return this.exportdownload(this.t);
        }
        if (this.cmd.compareTo("forceselftest") == 0) {
            return this.selftest(tseStatus, true);
        }
        if (this.cmd.compareTo("selftest") == 0) {
            return this.selftest(tseStatus, false);
        }
        if (this.cmd.compareTo("getlog") == 0) {
            return TseAdminCommand.getlog();
        }
        if (this.cmd.compareTo("check") == 0) {
            return this.check(tseStatus);
        }
        if (this.cmd.compareTo("userunblock") == 0) {
            return this.userunblock(tseStatus);
        }
        return new CommandResult(false, "No valid command sent: " + this.cmd);
    }

    private CommandResult selftest(ITseStatus tseStatus, boolean force) {
        return TseCmdExecutor.selftest(tseStatus, force, this.mountPoint, this.clientid, logger, this.pin);
    }

    private CommandResult decom(String clientid) {
        return TseCmdExecutor.decom(this.mountPoint, clientid, logger);
    }

    public CommandResult setup(ITseStatus tseStatus, boolean doFactoryReset) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (WormStore wormStore = new WormStore(this.mountPoint);){
                String out = "";
                CommandResult result = null;
                result = doFactoryReset ? this.factoryReset(tseStatus, wormStore) : this.setupTask(tseStatus, wormStore);
                if (result.isOk()) {
                    logger.log2("Start InfoTask");
                    out = String.valueOf(out) + this.infoTask(wormStore).toString() + "\n";
                    logger.log2("Completed InfoTask. Out=" + out);
                } else {
                    out = String.valueOf(result.toString()) + "\n";
                }
                return new CommandResult(true, out);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            return new CommandResult(false, "Exception: " + e.getMessage());
        }
    }

    private CommandResult userunblock(ITseStatus tseStatus) {
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (WormStore wormStore = new WormStore(this.mountPoint);){
                logger.log2("Start userunblock");
                wormStore.user_unblock(WormUserId.WORM_USER_ADMIN, this.puk, this.pin);
                logger.log2("Completed userunblock");
                return new CommandResult(true, "User unblocked");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (WormAuthenticationFailedException authEx) {
            return new CommandResult(false, "WormAuthenticationFailedException: " + authEx.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            return new CommandResult(false, "Exception: " + e.getMessage());
        }
    }

    private CommandResult factoryReset(ITseStatus tseStatus, WormStore wormStore) {
        String log = "";
        wormStore.tse_factoryReset();
        try {
            logger.log0("Start Self Test");
            wormStore.tse_runSelfTest(this.clientid);
            logger.log0("Completed Self Test");
            log = String.valueOf(log) + "Self Test completed. ";
        }
        catch (WormException e) {
            if (e.error() != WormError.WORM_ERROR_CLIENT_NOT_REGISTERED) {
                return new CommandResult(true, log);
            }
            log = String.valueOf(log) + "Eception: " + e.getMessage();
            return new CommandResult(false, log);
        }
        return new CommandResult(true, log);
    }

    private CommandResult setupTask(ITseStatus tseStatus, WormStore wormStore) {
        String log = "";
        WormInitializationState initState = wormStore.info().initializationState();
        logger.log0("TSE init state = " + initState.toString());
        log = String.valueOf(log) + "Init state = " + initState.toString() + ".";
        if (initState != WormInitializationState.WORM_INIT_UNINITIALIZED) {
            logger.log0("TSE was already intialized - setup not done");
            log = String.valueOf(log) + "TSE was already intialized - setup not done";
            return new CommandResult(false, log);
        }
        try {
            logger.log0("Start a self test before doing the setup. An exception WORM_ERROR_CLIENT_NOT_REGISTERED is expected");
            wormStore.tse_runSelfTest(this.clientid);
        }
        catch (WormException wormException) {
            logger.log0("Self Test returned with this exception: " + wormException.getMessage());
        }
        logger.log0("Start Setup");
        wormStore.tse_setup("SwissbitSwissbit".getBytes(StandardCharsets.UTF_8), this.puk, this.pin, this.pin, this.clientid);
        logger.log0("Completed Setup");
        log = String.valueOf(log) + "Setup completed. ";
        logger.log2("Start Login");
        wormStore.user_login(WormUserId.WORM_USER_ADMIN, this.pin);
        logger.log2("Logged in");
        long timestamp = System.currentTimeMillis() / 1000L;
        wormStore.tse_updateTime(timestamp);
        log = String.valueOf(log) + "Time updated";
        if (!wormStore.info().hasValidTime()) {
            wormStore.tse_setup("SwissbitSwissbit".getBytes(StandardCharsets.UTF_8), this.puk, this.pin, this.pin, this.clientid);
        }
        wormStore.tse_registerClient(this.clientid);
        logger.log0("Client registered: " + this.clientid);
        return new CommandResult(true, log);
    }

    private CommandResult infoTask(WormStore wormStore) {
        try {
            if (wormStore == null) {
                wormStore = new WormStore(this.mountPoint);
            }
        }
        catch (Exception e) {
            return new CommandResult(false, "WormStore cannot be opened: " + e.getMessage());
        }
        try {
            Throwable e = null;
            Object var3_6 = null;
            try (WormInformation information = wormStore.info();){
                long remainingSignatures = wormStore.info().remainingSignatures();
                String remainingSignaturesTxt = "Anzahl verbleibender Signaturen: " + remainingSignatures;
                if (remainingSignatures < 1L) {
                    remainingSignaturesTxt = String.valueOf(remainingSignaturesTxt) + " (TSE auswechseln!)";
                }
                long certExpirationDate = wormStore.info().certificateExpirationDate();
                long timestamp = System.currentTimeMillis() / 1000L;
                String certValidTxt = "";
                if (certExpirationDate <= timestamp) {
                    certValidTxt = "Zertifikat ist abgelaufen! TSE auswechseln!\n";
                }
                String initStateStr = "TSE initialization state undefined";
                WormInitializationState initState = wormStore.info().initializationState();
                if (initState == WormInitializationState.WORM_INIT_DECOMMISSIONED) {
                    initStateStr = "TSE decommissioned";
                } else if (initState == WormInitializationState.WORM_INIT_INITIALIZED) {
                    initStateStr = "TSE is initialized";
                } else if (initState == WormInitializationState.WORM_INIT_UNINITIALIZED) {
                    initStateStr = "TSE is uninitialized";
                }
                byte[] customizationIdentifier = wormStore.info().customizationIdentifier();
                String custIdent = BaseTseCommand.bytesToHex(customizationIdentifier);
                SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
                String result = "TseDescription: " + information.tseDescription() + "\n";
                result = String.valueOf(result) + "Serial Number: " + TseAdminCommand.bytesToHex(information.tseSerialNumber()) + "\n";
                result = String.valueOf(result) + "Hardware Version: " + information.hardwareVersion() + "\n";
                result = String.valueOf(result) + "Size: " + information.size() + "\n";
                result = String.valueOf(result) + "Tar Export Size: " + information.tarExportSize() + "\n";
                result = String.valueOf(result) + "Public Key: " + TseAdminCommand.bytesToHex(information.tsePublicKey()) + "\n";
                result = String.valueOf(result) + "certificateExpirationDate: " + f.format(information.certificateExpirationDate() * 1000L) + "\n";
                result = String.valueOf(result) + "Created Signatures: " + information.createdSignatures() + "\n";
                result = String.valueOf(result) + "hasValidTime: " + information.hasValidTime() + "\n";
                result = String.valueOf(result) + "Worm State: " + initStateStr + "\n";
                result = String.valueOf(result) + "IsCtssInterfaceActive = " + wormStore.info().isCtssInterfaceActive() + "\n";
                result = String.valueOf(result) + "HasChangedAdminPin = " + wormStore.info().hasChangedAdminPin() + "\n";
                result = String.valueOf(result) + "HadChangedTimeAdminPin = " + wormStore.info().hasChangedTimeAdminPin() + "\n";
                result = String.valueOf(result) + "HasChangedPUK = " + wormStore.info().hasChangedPuk() + "\n";
                result = String.valueOf(result) + "IsDeveloppmentFirmware = " + wormStore.info().isDevelopmentFirmware() + "\n";
                result = String.valueOf(result) + "Software version = " + wormStore.info().softwareVersion() + "\n";
                result = String.valueOf(result) + "Needs replacement = " + wormStore.flashHealthSummary().needsReplacement() + "\n";
                result = String.valueOf(result) + "CustomizationIdentifier = " + custIdent + "\n";
                result = String.valueOf(result) + "Form Factor of TSE=" + wormStore.info().formFactor() + "\n";
                result = String.valueOf(result) + remainingSignaturesTxt + "\n";
                result = String.valueOf(result) + certValidTxt;
                return new CommandResult(true, result);
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (Exception e) {
            return new CommandResult(false, e.getMessage());
        }
    }

    private CommandResult export_to_local_tmp(ITseStatus tseStatus) {
        WormStore wormStore;
        if (tseStatus.isBusy()) {
            return new CommandResult(false, "TSE is busy");
        }
        tseStatus.setIsBusy(true);
        try {
            wormStore = new WormStore(this.mountPoint);
        }
        catch (Exception e) {
            tseStatus.setIsBusy(false);
            return new CommandResult(false, "WormStore cannot be opened: " + e.getMessage());
        }
        final String exportFile = tseStatus.getTarExportFile();
        WormExportTarCallback callback = new WormExportTarCallback(){

            public int onNewData(byte[] data) {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (FileOutputStream output = new FileOutputStream(exportFile, true);){
                        output.write(data);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return -1;
                }
                return 0;
            }
        };
        wormStore.export_tar(callback);
        wormStore.close();
        tseStatus.setIsBusy(false);
        return new CommandResult(true, "Export completed");
    }

    private CommandResult exportdownload(final HttpExchange t) {
        WormStore wormStore;
        System.out.println("Start TSE Tar-Download");
        try {
            wormStore = new WormStore(this.mountPoint);
        }
        catch (Exception e) {
            return new CommandResult(false, "WormStore cannot be opened: " + e.getMessage());
        }
        t.getResponseHeaders().set("Content-Type", "application/x-tar ");
        t.getResponseHeaders().add("Content-Disposition", "filename=tse-export.tar");
        try {
            t.sendResponseHeaders(200, 0L);
            System.out.println("Tar-Download: Header 200 sent");
        }
        catch (IOException e1) {
            e1.printStackTrace();
            wormStore.close();
            return new CommandResult(false, "Cannot send data: " + e1.getMessage());
        }
        WormExportTarCallback callback = new WormExportTarCallback(){

            public int onNewData(byte[] data) {
                try {
                    t.getResponseBody().write(data);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return -1;
                }
                return 0;
            }
        };
        wormStore.export_tar(callback);
        wormStore.close();
        System.out.println("Tar-Download: Content sent");
        try {
            t.getResponseBody().close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return new CommandResult(false, "Problem: " + e.getMessage());
        }
        t.close();
        System.out.println("Tar-Download: Closed HttpExchange");
        return new CommandResult(true, "Export completed");
    }

    private CommandResult export_sollte_geht_aber_nicht(HttpExchange t) {
        WormStore wormStore;
        File f;
        try {
            f = File.createTempFile("tseoutput", null);
            logger.log2("Use temporary file: " + f.getName());
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return new CommandResult(false, "tmp file not created");
        }
        try {
            wormStore = new WormStore(this.mountPoint);
        }
        catch (Exception e) {
            return new CommandResult(false, "WormStore cannot be opened: " + e.getMessage());
        }
        WormExportTarCallback callback = new WormExportTarCallback(){

            public int onNewData(byte[] data) {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (FileOutputStream output = new FileOutputStream(f, true);){
                        output.write(data);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return -1;
                }
                return 0;
            }
        };
        wormStore.export_tar(callback);
        wormStore.close();
        t.getResponseHeaders().set("Content-Type", "application/x-tar ");
        t.getResponseHeaders().add("Content-Disposition", "filename=tse-export.tar");
        try {
            this.sendFileResponse(f, t);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new CommandResult(true, "Export completed");
    }

    private void sendFileResponse(File file, HttpExchange httpExchange) throws IOException {
        OutputStream responseBody = null;
        FileInputStream in = null;
        try {
            try {
                int read;
                in = new FileInputStream(file);
                httpExchange.sendResponseHeaders(200, file.length());
                responseBody = httpExchange.getResponseBody();
                byte[] buffer = new byte[4096];
                while ((read = ((InputStream)in).read(buffer)) != -1) {
                    logger.log2("Ein Chunk");
                    responseBody.write(buffer, 0, read);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (responseBody != null) {
                    responseBody.close();
                }
                ((InputStream)in).close();
            }
            catch (IOException e) {
                block11: {
                    e.printStackTrace();
                    if (responseBody == null) break block11;
                    responseBody.close();
                }
                ((InputStream)in).close();
            }
        }
        finally {
            if (responseBody != null) {
                responseBody.close();
            }
            ((InputStream)in).close();
        }
    }

    private CommandResult export_failed(final HttpExchange t) {
        WormStore wormStore;
        try {
            wormStore = new WormStore(this.mountPoint);
        }
        catch (Exception e) {
            return new CommandResult(false, "WormStore cannot be opened: " + e.getMessage());
        }
        t.getResponseHeaders().set("Content-Type", "application/x-tar ");
        t.getResponseHeaders().add("Content-Disposition", "filename=tse-export.tar");
        try {
            t.sendResponseHeaders(200, 0L);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        WormExportTarCallback callback = new WormExportTarCallback(){

            public int onNewData(byte[] data) {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (BufferedOutputStream out = new BufferedOutputStream(t.getResponseBody());){
                        out.write(data);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return -1;
                }
                return 0;
            }
        };
        wormStore.export_tar(callback);
        wormStore.close();
        try {
            t.getResponseBody().flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new CommandResult(true, "Export completed");
    }

    private static CommandResult getlog() {
        return new CommandResult(true, logger.output(false));
    }

    private CommandResult check(ITseStatus tseStatus) {
        if (tseStatus.isBusy()) {
            return new CommandResult(false, "TSE is busy");
        }
        if (!tseStatus.isCheckUseful()) {
            logger.log2("Ignore Check request - last check not that far in the past");
            return new CommandResult(true, "OK");
        }
        tseStatus.setIsBusy(true);
        tseStatus.setLastCheckResult(false);
        logger.log2("Check for TSE Status and availability");
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (WormStore wormStore = new WormStore(this.mountPoint);){
                long timestamp;
                long remainingSignatures;
                long timeUntilNextSelfTestInSeconds;
                if (!wormStore.info().hasPassedSelfTest()) {
                    logger.log0("TSE has no valid self test due to info from WormInformation instance. Start self test now.");
                    CommandResult cres = TseCmdExecutor.selftest(tseStatus, true, this.mountPoint, this.clientid, logger, this.pin);
                    if (!cres.isOk()) {
                        tseStatus.setIsBusy(false);
                        return cres;
                    }
                }
                if ((timeUntilNextSelfTestInSeconds = wormStore.info().timeUntilNextSelfTest()) < 14400L) {
                    logger.log0("TSE has no valid self test because next self test is in less than 4 hours. Start self test now.");
                    CommandResult cres = TseCmdExecutor.selftest(tseStatus, true, this.mountPoint, this.clientid, logger, this.pin);
                    if (!cres.isOk()) {
                        tseStatus.setIsBusy(false);
                        return cres;
                    }
                }
                if ((remainingSignatures = wormStore.info().remainingSignatures()) < 1L) {
                    logger.log0("No more available TSE signatures");
                    tseStatus.setIsBusy(false);
                    return new CommandResult(false, "No more available TSE signatures!");
                }
                long certExpirationDate = wormStore.info().certificateExpirationDate();
                if (certExpirationDate <= (timestamp = System.currentTimeMillis() / 1000L)) {
                    logger.log0("Certificate of TSE has expired");
                    tseStatus.setIsBusy(false);
                    return new CommandResult(false, "Certificate of TSE has expired!");
                }
                if (wormStore.info().initializationState() != WormInitializationState.WORM_INIT_INITIALIZED) {
                    return new CommandResult(false, "WormStore not initialized - do not try to log in. Stopping check.");
                }
                wormStore.user_login(WormUserId.WORM_USER_ADMIN, this.pin);
                wormStore.tse_registerClient(this.clientid);
                boolean timeCheck = this.doTimeCheckAndUpdate(tseStatus);
                tseStatus.setIsBusy(false);
                if (timeCheck) {
                    tseStatus.setLastCheckResult(true);
                    tseStatus.setSuccessfulCheckIsDone();
                    return new CommandResult(true, "OK");
                }
                tseStatus.setLastCheckResult(false);
                return new CommandResult(false, "Time check not successful");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            tseStatus.setIsBusy(false);
            return new CommandResult(false, "Exception: " + e.getMessage());
        }
    }

    private boolean doTimeCheckAndUpdate(ITseStatus tseStatus) {
        Object cres;
        Object var7_14;
        Throwable throwable;
        long timestamp = System.currentTimeMillis() / 1000L;
        boolean timeNeedsToBeSet = false;
        try {
            Throwable throwable2 = null;
            throwable = null;
            try (WormStore wormStore = new WormStore(this.mountPoint);){
                boolean hasValidTime = wormStore.info().hasValidTime();
                if (!hasValidTime) {
                    logger.log2("TSE has no valid time. Set time now.");
                    timeNeedsToBeSet = true;
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Exception ex) {
            logger.log0("TSE info about time status could not be retrieved: " + ex.getMessage());
        }
        if (!tseStatus.isTseTimeSet()) {
            logger.log2("TSE needs time sync because soon expiration of maxSyncTime after last time sync");
            timeNeedsToBeSet = true;
        }
        boolean selfTestNeeded = false;
        if (timeNeedsToBeSet) {
            try {
                throwable = null;
                var7_14 = null;
                try (WormStore wormStore = new WormStore(this.mountPoint);){
                    wormStore.tse_updateTime(timestamp);
                    tseStatus.setTseTimeSet(true);
                    logger.log2("TSE time is set");
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (Exception ex) {
                selfTestNeeded = true;
                logger.log0("TSE update time resulted into an error so self test will be triggered. Error message: " + ex.getMessage());
            }
        }
        if (selfTestNeeded && !((CommandResult)(cres = TseCmdExecutor.selftest(tseStatus, true, this.mountPoint, this.clientid, logger, this.pin))).isOk()) {
            logger.log0("TSE self test went wrong");
            return false;
        }
        selfTestNeeded = false;
        try {
            cres = null;
            var7_14 = null;
            try (WormStore wormStore = new WormStore(this.mountPoint);){
                timestamp = System.currentTimeMillis() / 1000L;
                wormStore.tse_updateTime(timestamp);
                tseStatus.setTseTimeSet(true);
                logger.log2("TSE time is set");
                selfTestNeeded = !wormStore.info().hasPassedSelfTest();
            }
            catch (Throwable throwable5) {
                if (cres == null) {
                    cres = throwable5;
                } else if (cres != throwable5) {
                    ((Throwable)cres).addSuppressed(throwable5);
                }
                throw cres;
            }
        }
        catch (Exception ex) {
            logger.log0("TSE update time resulted into an error: " + ex.getMessage());
            return false;
        }
        if (selfTestNeeded && !((CommandResult)(cres = TseCmdExecutor.selftest(tseStatus, true, this.mountPoint, this.clientid, logger, this.pin))).isOk()) {
            logger.log0("TSE self test went wrong");
            return false;
        }
        return true;
    }
}

