/*
 * Decompiled with CFR 0.152.
 */
package tseconnector.commands;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.secureflashcard.wormapi.WormEntry;
import com.secureflashcard.wormapi.WormError;
import com.secureflashcard.wormapi.WormException;
import com.secureflashcard.wormapi.WormStore;
import com.secureflashcard.wormapi.WormTransactionResponse;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.json.simple.JSONObject;
import tseconnector.ITseStatus;
import tseconnector.commands.BaseTseCommand;
import tseconnector.commands.CommandResult;
import tseconnector.commands.TseCmdExecutor;

public class TseSignCommand
extends BaseTseCommand {
    public String value;
    @JsonIgnore
    public static String correctPass = "";

    @Override
    public CommandResult doCmd(ITseStatus tseStatus) {
        if (this.cmd.compareTo("signorders") == 0) {
            return this.signvalue(tseStatus, "Bestellung-V1");
        }
        if (this.cmd.compareTo("signnormalbill") == 0) {
            return this.signvalue(tseStatus, "Kassenbeleg-V1");
        }
        if (this.cmd.compareTo("signfreecontent") == 0) {
            return this.signvalue(tseStatus, "SonstigerVorgang");
        }
        return new CommandResult(false, "No valid command sent: " + this.cmd);
    }

    private CommandResult signvalue(ITseStatus tseStatus, String processType) {
        CommandResult makeReadyResult = this.makeTseReady(tseStatus);
        if (!makeReadyResult.isOk()) {
            return new CommandResult(false, "TSE not ready");
        }
        boolean tseIsReady = this.waitForTseReady(tseStatus);
        if (!tseIsReady) {
            return new CommandResult(false, "TSE not ready");
        }
        logger.log1("Starte Signierung");
        WormTransactionResponse response = null;
        try {
            Throwable throwable = null;
            Object var7_10 = null;
            try (WormStore wormStore = new WormStore(this.mountPoint);){
                String sigAlg = WormStore.signatureAlgorithm();
                TseCmdExecutor.completeUnfinishedTransactions(wormStore, this.clientid, logger, 0);
                response = wormStore.transaction_start(this.clientid, new byte[0], "");
                response = wormStore.transaction_finish(this.clientid, response.transactionNumber(), this.value.getBytes(StandardCharsets.UTF_8), processType);
                WormEntry entry = wormStore.lastEntry();
                long time = response.logTime();
                long sigCounter = response.signatureCounter();
                long trans = response.transactionNumber();
                byte[] signature = response.signature();
                String signatureBase64 = Base64.getEncoder().encodeToString(signature);
                byte[] tseSerialNo = response.serialNumber();
                String serialNoBase64 = Base64.getEncoder().encodeToString(tseSerialNo);
                byte[] tsePublicKey = wormStore.info().tsePublicKey();
                String tsePublicKeyBase64 = Base64.getEncoder().encodeToString(tsePublicKey);
                String tseCertificate = Base64.getEncoder().encodeToString(wormStore.getLogMessageCertificate());
                long timeUntilNextTimeSynchronization = wormStore.info().timeUntilNextTimeSynchronization();
                if (timeUntilNextTimeSynchronization != 0L && timeUntilNextTimeSynchronization < 300L) {
                    tseStatus.setTseTimeSet(false);
                }
                logger.log1("  Last Transaction Details");
                logger.log1("  Log Time: " + time);
                logger.log1("  Signature Counter: " + sigCounter);
                logger.log1("  Transaction Number: " + trans);
                logger.log1("  Log Message Length: " + entry.logMessageLength());
                logger.log1("  Process Data Length: " + entry.processDataLength());
                logger.log1("  Log Message:\n" + TseSignCommand.bytesToHex(entry.readLogMessage()));
                logger.log1("  SigAlg: " + sigAlg);
                logger.log1("  Signature: " + signatureBase64);
                logger.log1("  TSESerialNo: " + serialNoBase64);
                logger.log1("  TSEPublicKey: " + tsePublicKeyBase64);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put((Object)"logtime", (Object)time);
                jsonObject.put((Object)"trans", (Object)trans);
                jsonObject.put((Object)"sigcounter", (Object)sigCounter);
                jsonObject.put((Object)"sigalg", (Object)sigAlg);
                jsonObject.put((Object)"signature", (Object)signatureBase64);
                jsonObject.put((Object)"publickey", (Object)tsePublicKeyBase64);
                jsonObject.put((Object)"serialno", (Object)TseSignCommand.bytesToHex(tseSerialNo));
                jsonObject.put((Object)"certificate", (Object)tseCertificate);
                return new CommandResult(true, jsonObject);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (WormException wormException) {
            if (wormException.error().equals((Object)WormError.WORM_ERROR_NO_TIME_SET)) {
                tseStatus.setTseTimeSet(false);
                return new CommandResult(false, "No signing possible: Exception because time was not set.");
            }
            wormException.printStackTrace();
            return new CommandResult(false, "No signing possible: Exception: " + wormException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            return new CommandResult(false, "No signing possible: Exception: " + e.getMessage());
        }
    }
}

