/*
 * Decompiled with CFR 0.152.
 */
package tseconnector.commands.sim;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.Instant;
import java.util.Base64;
import org.json.simple.JSONObject;
import tseconnector.ITseStatus;
import tseconnector.commands.CommandResult;
import tseconnector.commands.sim.BaseTseCommandSimulation;

public class TseSignCommandSimulation
extends BaseTseCommandSimulation {
    private static long staticSigCounter = 0L;
    private static long staticTransNumber = 0L;
    private static int signatureCounter = 0;
    public String value;
    @JsonIgnore
    public static String correctPass = "";
    @JsonIgnore
    private String[] signatures = new String[]{"fbaGExar80UOZ3XzwvALfsO/W4v46g6KWRrWtMYrPBeDnzAP5KOu/JNtTim32M+XcdUpd2WZmdUH6uMyqHNWFYsBRM/xXuH40STg2Y+V2mWJjO8Hdtrh4BGxs1vwds5G", "JGNc9+EDFSF4wdXwWk9JlcaCQNjab+gEmpEkG6R78bJ2hHDIDcKO2ubFKyQFcJOXXhaPrMuTMnU6qZF5s6xKlieHe+1DWGvSS2JXOCbnUvlhfSlT7rTWCyjlfBm3K4Yx", "c6B4Mhj0kL/w7OCcFmfBvSA0x4QrAGfvUiQaYr9YyQXJI8KnKJjPz+NHwmSZnHjmgrruHMEf6b5bVlpUMLZcEHfoej5FTy51Pzz1+mV0vSeOIAOIXpD96+wRpRwwZp8B", "h8YfZwXyIIa7cFi5NpKAeATutbiU6UX0RNMnWojwQ1fmqv2hXUOzFPb7Ijf3X2K0L8PwSPmiE/m8j0zKVy4ujIzwwD5+IEk5/79J7ZgWSpI8ECzIu2yEW1gZXmy1xzAs", "QWWAzhyH5ymMzKa/O1dFrRttnNrPSXaXWNJRFr/YER5UBhhcpduwneiuhguM1tpRWTUsh+qysXsqUl39Zh14VeITQib2tWxpUrX778V7CrZ4q2yY+8ExppfflHCRoiYc", "QMcOaBXP1cukbHuF3JH/7XJcb+u9hZz4qmvpLjuAYkcOYPPCtRzKqUmiI8x9SRwbN5q7BkcUdSJHzsApc+A+DVU8So9djChBi6RnsC7rzE31XH8ypBG5V4DF1MLfyeYC"};
    @JsonIgnore
    private String serialNo = "7E5B69CC5E41C803F17242DAC2B3664D33FC2C1039FE892AB0B1D81FF695A7AA";

    @Override
    public CommandResult doCmd(ITseStatus tseStatus) {
        if (this.cmd.compareTo("signorders") == 0) {
            return this.signvalue(tseStatus, "Bestellung-V1");
        }
        if (this.cmd.compareTo("signnormalbill") == 0) {
            return this.signvalue(tseStatus, "Kassenbeleg-V1");
        }
        if (this.cmd.compareTo("signfreecontent") == 0) {
            return this.signvalue(tseStatus, "SonstigerVorgang");
        }
        return new CommandResult(false, "No valid command sent: " + this.cmd);
    }

    private CommandResult signvalue(ITseStatus tseStatus, String processType) {
        CommandResult makeReadyResult = this.makeTseReady(tseStatus);
        if (!makeReadyResult.isOk()) {
            return makeReadyResult;
        }
        boolean tseIsReady = this.waitForTseReady(tseStatus);
        if (!tseIsReady) {
            return new CommandResult(false, "TSE not ready");
        }
        logger.log1("Starte Simulation der Signierung");
        long sigCounter = ++staticSigCounter;
        long trans = ++staticTransNumber;
        String signatureBase64 = this.signatures[signatureCounter];
        signatureCounter = (signatureCounter + 1) % this.signatures.length;
        String tsePublicKeyBase64 = "BFa72LLBEGO5ycFraOubP491AuEnnaikkJqt9CcCIMVyyxdbR+O7f1QYBsoX4zuuzyOCPhKvohCwm6OrJujdimZQVLqUsYj6KSh/S07bqxZ6d/5npEKEmx9pNRy0b1qQOg==";
        String tseCertificate = Base64.getEncoder().encodeToString(new byte[]{10, 20, 30});
        byte[] tseSerialNo = new byte[]{1, 2, 3, 4, 5, 6, 7};
        String serialNoBase64 = Base64.getEncoder().encodeToString(tseSerialNo);
        long time = Instant.now().getEpochSecond();
        String sigAlg = "ecdsa-plain-SHA384";
        logger.log1("  Last Transaction Details");
        logger.log1("  Log Time: " + time);
        logger.log1("  Signature Counter: " + sigCounter);
        logger.log1("  Transaction Number: " + trans);
        logger.log1("  Log Message Length: 3081DC020102060904007F000703070101801146696E6973685472616E73616374696F6E810...");
        logger.log1("  SigAlg: " + sigAlg);
        logger.log1("  Signature: " + signatureBase64);
        logger.log1("  TSESerialNo: " + serialNoBase64);
        logger.log1("  TSEPublicKey: " + tsePublicKeyBase64);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"status", (Object)"OK");
        jsonObject.put((Object)"logtime", (Object)time);
        jsonObject.put((Object)"trans", (Object)trans);
        jsonObject.put((Object)"sigcounter", (Object)sigCounter);
        jsonObject.put((Object)"sigalg", (Object)sigAlg);
        jsonObject.put((Object)"signature", (Object)signatureBase64);
        jsonObject.put((Object)"publickey", (Object)tsePublicKeyBase64);
        jsonObject.put((Object)"serialno", (Object)this.serialNo);
        jsonObject.put((Object)"certificate", (Object)tseCertificate);
        return new CommandResult(true, jsonObject);
    }
}

