/*
 * Decompiled with CFR 0.152.
 */
package tseconnector;

import com.secureflashcard.wormapi.WormInformation;
import com.secureflashcard.wormapi.WormStore;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import tseconnector.Server;
import tseconnector.TseConnectorLog;
import tseconnector.TseLocator;
import tseconnector.TseStatus;
import tseconnector.commands.TseAdminCommand;
import tseconnector.commands.TseSignCommand;
import tseconnector.commands.sim.TseAdminCommandSimulation;
import tseconnector.commands.sim.TseSignCommandSimulation;

public class tseconnector {
    private static String version = "2.4";

    public static void main(String[] args) {
        int showLogInWeb;
        Mode mode;
        String mountPoint;
        String supplier;
        int port;
        String pass;
        TseStatus tseStatus;
        TseConnectorLog logger;
        block44: {
            logger = new TseConnectorLog(true);
            if (args.length == 0) {
                logger.log0("Keine Aufrufparameter \u00fcbergeben. Standardwerte werden benutzt!");
            }
            tseStatus = new TseStatus();
            TseAdminCommand.logger = logger;
            TseAdminCommandSimulation.logger = logger;
            TseSignCommand.logger = logger;
            TseSignCommandSimulation.logger = logger;
            pass = "123";
            port = 8000;
            supplier = "swissbit";
            mountPoint = "auto";
            mode = Mode.Normal;
            int loglevel = 0;
            showLogInWeb = 1;
            String tarexportfile = "/tmp/tsetar";
            System.out.println("TSEConnectors kann folgende Parameter verarbeiten: ");
            System.out.println("   --version      Ausgabe der TSEConnector-Version. Wird dieses Argument eingesetzt, beendet sich der TSEConnector nach der Versionsangabe.");
            System.out.println("   --pass=xyz     Das Passwort des TSEConnectors. In der OrderSprinter-Administrationsansicht einstellen!");
            System.out.println("   --port=8000    Der TCP-Port, \u00fcber den OrderSprinter-Core mit dem TSEConnector kommunizieren soll");
            System.out.println("   --mountpoint=/media/account/SWISSBIT   Das Laufwerk/Mountpoint der Swissbit-TSE oder \"auto\" wenn TSE automatisch gesucht werden soll.");
            System.out.println("   --mode=normal  Falls der Wert auf \"simulate\" eingestellt wird, wird die TSE nur simuliert.");
            System.out.println("   --loglevel=number  0: nur relevante Infos, 1: Signierungen, 2: umfangreiches Logging.\n");
            System.out.println("   --showlog=number  0: kein Zugriff auf Log via Web, 1: Zugriff erlauben ohne Passwortabfrage (default: 1)\n");
            System.out.println("   --exportdir=Verzeichnis zum Abspeichern des TSE-Tar-Exports (einen Pfad ohne Leerzeichen verwenden!)\n");
            System.out.println("Zus\u00e4tzlich muss der Pfad zum Verzeichnis tseconnector_lib angegeben werden (sonst wird ein java.lang.UnsatisfiedLinkError gemeldet):");
            System.out.println("   z.B. java -Djava.library.path=/usr/local/bin/tseconnector/swissbit/nativelibs/linux64 -jar tseconnector.jar mode=...");
            System.out.println("   Die Angabe zum java.library.path h\u00e4ngt von der verwendeten Umgebung ab, Raspberry Pi werden z.B. nicht unterst\u00fctzt (ARM).\n");
            try {
                int i = 0;
                while (i < args.length) {
                    if (args[i].compareToIgnoreCase("version") == 0 || args[i].compareToIgnoreCase("--version") == 0 || args[i].compareToIgnoreCase("-v") == 0) {
                        System.out.println("Version: " + version);
                        System.exit(0);
                    }
                    String[] argParts = args[i].split("=", 2);
                    String parameter = argParts[0].trim();
                    String value = argParts[1].trim();
                    if (parameter.compareToIgnoreCase("pass") == 0 || parameter.compareToIgnoreCase("--pass") == 0) {
                        pass = value;
                    } else if (parameter.compareToIgnoreCase("port") == 0 || parameter.compareToIgnoreCase("--port") == 0) {
                        port = Integer.parseInt(value);
                    } else if (parameter.compareToIgnoreCase("supplier") == 0 || parameter.compareToIgnoreCase("--supplier") == 0) {
                        supplier = value;
                    } else if (parameter.compareToIgnoreCase("mountpoint") == 0 || parameter.compareToIgnoreCase("--mountpoint") == 0) {
                        mountPoint = value;
                    } else if (parameter.compareToIgnoreCase("loglevel") == 0 || parameter.compareToIgnoreCase("--loglevel") == 0) {
                        loglevel = Integer.parseInt(value);
                    } else if (parameter.compareToIgnoreCase("mode") == 0 || parameter.compareToIgnoreCase("--mode") == 0) {
                        if (value.compareToIgnoreCase("simulate") == 0) {
                            mode = Mode.Simulation;
                        }
                    } else if (parameter.compareToIgnoreCase("showlog") == 0 || parameter.compareToIgnoreCase("--showlog") == 0) {
                        showLogInWeb = Integer.parseInt(value);
                    } else if (parameter.compareToIgnoreCase("tarexportfile") == 0 || parameter.compareToIgnoreCase("--tarexportfile") == 0) {
                        tarexportfile = value;
                    }
                    tseStatus.setMode(mode);
                    ++i;
                }
            }
            catch (Exception e) {
                System.err.println("Aufrufparameter konnten nicht verarbeitet werden. Ein korrekter Aufruf sieht z.B. so aus: ");
                System.err.println("   --pass=123 --port=8000 --supplier=swissbit --mountpount=/dev/abc --mode=normal --loglevel=1 --showlog=1 --tarexportfile=/tmp/tarfile");
                System.err.println("Der TSEConnector wird mit Standardwerten gestartet");
            }
            if (mountPoint.toLowerCase().compareTo("auto") == 0 && mode == Mode.Normal) {
                TseLocator tseLocator = new TseLocator();
                String tseDevicePath = tseLocator.findTse();
                if (tseDevicePath != null) {
                    mountPoint = tseDevicePath;
                    logger.log0("TSE gefunden unter " + mountPoint);
                } else {
                    logger.log0("Keine TSE gefunden, wurde sie eingeh\u00e4ngt?");
                }
            }
            logger.log0("Start TSEConnector mit diesen Parametern:");
            logger.log0("  pass=         " + pass);
            logger.log0("  port=         " + port);
            logger.log0("  supplier=     " + supplier);
            logger.log0("  mountpoint=   " + mountPoint);
            logger.log0("  mode=         " + (mode == Mode.Normal ? "normal" : "simulate"));
            logger.log0("  loglevel=     " + loglevel);
            logger.log0("  showlog=      " + showLogInWeb);
            logger.log0("  tarexportfile=" + tarexportfile);
            logger.log0("TSEConnector-Version: " + version);
            logger.setLoglevel(loglevel);
            tseStatus.setLogger(logger);
            tseStatus.setTarExportFile(tarexportfile);
            if (mode == Mode.Normal) {
                boolean mountDone = false;
                File file = new File(mountPoint);
                while (!mountDone) {
                    if (file.isDirectory()) {
                        mountDone = true;
                    } else {
                        System.err.println("TSE not mounted yet - check again in some seconds...");
                    }
                    if (mountDone) continue;
                    try {
                        TimeUnit.SECONDS.sleep(10L);
                    }
                    catch (InterruptedException parameter) {
                        // empty catch block
                    }
                }
                System.out.println("TSE seems to be mounted");
            }
            if (mode == Mode.Normal) {
                try {
                    Throwable mountDone = null;
                    Object var12_20 = null;
                    try (WormStore wormStore = new WormStore(mountPoint);){
                        WormInformation wormInfo = wormStore.info();
                        long syncTime = wormInfo.maxTimeSynchronizationDelay();
                        System.out.println("Sync Time = " + syncTime + " seconds (" + syncTime / 60L + " minutes)");
                        tseStatus.setSyncDurationTime(syncTime - 120L);
                        break block44;
                    }
                    catch (Throwable throwable) {
                        if (mountDone == null) {
                            mountDone = throwable;
                        } else if (mountDone != throwable) {
                            mountDone.addSuppressed(throwable);
                        }
                        throw mountDone;
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    return;
                }
            }
            tseStatus.setSyncDurationTime(600L);
        }
        try {
            Server e = new Server(pass, port, supplier, mountPoint, tseStatus, logger, mode, showLogInWeb);
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.log0("Server konnte nicht initialisiert werden: " + e.getMessage());
        }
        logger.log0("Abgeschlossen Startup des TSEConnectors");
    }

    public static enum Mode {
        Normal,
        Simulation;

    }
}

